/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.numeric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import java.util.Optional;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;

public record BetweenNumericValidator(Optional<Number> min, Optional<Number> max) implements NumericValidator
{
    public static final String ID = "number:between";
    public static final Codec<BetweenNumericValidator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecExtras.NUMBER.optionalFieldOf("min").forGetter(BetweenNumericValidator::min), (App)CodecExtras.NUMBER.optionalFieldOf("max").forGetter(BetweenNumericValidator::max)).apply((Applicative)instance, BetweenNumericValidator::new));

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(NumericTag tag) {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            byte min = this.min.map(Number::byteValue).orElse((byte)-128);
            byte max = this.max.map(Number::byteValue).orElse((byte)127);
            return byteTag.getAsByte() >= min && byteTag.getAsByte() <= max;
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            short min = this.min.map(Number::shortValue).orElse((short)Short.MIN_VALUE);
            short max = this.max.map(Number::shortValue).orElse((short)Short.MAX_VALUE);
            return shortTag.getAsShort() >= min && shortTag.getAsShort() <= max;
        }
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            int min = this.min.map(Number::intValue).orElse(Integer.MIN_VALUE);
            int max = this.max.map(Number::intValue).orElse(Integer.MAX_VALUE);
            return intTag.getAsInt() >= min && intTag.getAsInt() <= max;
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            long min = this.min.map(Number::longValue).orElse(Long.MIN_VALUE);
            long max = this.max.map(Number::longValue).orElse(Long.MAX_VALUE);
            return longTag.getAsLong() >= min && longTag.getAsLong() <= max;
        }
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            float min = this.min.map(Number::floatValue).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
            float max = this.max.map(Number::floatValue).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
            return floatTag.getAsFloat() >= min && floatTag.getAsFloat() <= max;
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            double min = this.min.map(Number::doubleValue).orElse((Double)Double.MIN_VALUE);
            double max = this.max.map(Number::doubleValue).orElse((Double)Double.MAX_VALUE);
            return doubleTag.getAsDouble() >= min && doubleTag.getAsDouble() <= max;
        }
        return false;
    }
}

