/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.rufia.fightorflight.config.FightOrFlightCommonConfigModel;
import me.rufia.fightorflight.config.FightOrFlightMoveConfigModel;
import me.rufia.fightorflight.config.FightOrFlightVisualEffectConfigModel;
import me.rufia.fightorflight.data.movedata.movedatas.MiscMoveData;
import me.rufia.fightorflight.goals.PokemonAttackGoal;
import me.rufia.fightorflight.goals.PokemonAvoidGoal;
import me.rufia.fightorflight.goals.PokemonGoToPosGoal;
import me.rufia.fightorflight.goals.PokemonPanicGoal;
import me.rufia.fightorflight.net.CobblemonFightOrFlightNetwork;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.TargetingWhitelist;
import me.rufia.fightorflight.utils.listeners.BehaviorDataListener;
import me.rufia.fightorflight.utils.listeners.MoveDataListener;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonFightOrFlight {
    public static final String MODID = "fightorflight";
    public static final String COBBLEMON_MOD_ID = "cobblemon";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fightorflight");
    private static FightOrFlightCommonConfigModel commonConfig;
    private static FightOrFlightMoveConfigModel moveConfig;
    private static FightOrFlightVisualEffectConfigModel visualEffectConfig;
    private static TriConsumer<PokemonEntity, Integer, Goal> goalAdder;

    public static FightOrFlightCommonConfigModel commonConfig() {
        return commonConfig;
    }

    public static FightOrFlightMoveConfigModel moveConfig() {
        return moveConfig;
    }

    public static FightOrFlightVisualEffectConfigModel visualEffectConfig() {
        return visualEffectConfig;
    }

    public static void init(TriConsumer<PokemonEntity, Integer, Goal> goalAdder) {
        CobblemonFightOrFlight.goalAdder = goalAdder;
        AutoConfig.register(FightOrFlightCommonConfigModel.class, JanksonConfigSerializer::new);
        AutoConfig.register(FightOrFlightMoveConfigModel.class, JanksonConfigSerializer::new);
        AutoConfig.register(FightOrFlightVisualEffectConfigModel.class, JanksonConfigSerializer::new);
        commonConfig = (FightOrFlightCommonConfigModel)AutoConfig.getConfigHolder(FightOrFlightCommonConfigModel.class).getConfig();
        moveConfig = (FightOrFlightMoveConfigModel)AutoConfig.getConfigHolder(FightOrFlightMoveConfigModel.class).getConfig();
        visualEffectConfig = (FightOrFlightVisualEffectConfigModel)AutoConfig.getConfigHolder(FightOrFlightVisualEffectConfigModel.class).getConfig();
        CobblemonFightOrFlightNetwork.init();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new MoveDataListener(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"movedata"));
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new BehaviorDataListener(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"behaviordata"));
        TargetingWhitelist.init();
    }

    public static void addPokemonGoal(PokemonEntity pokemonEntity) {
        float minimum_movement_speed = CobblemonFightOrFlight.commonConfig().minimum_movement_speed;
        float maximum_movement_speed = CobblemonFightOrFlight.commonConfig().maximum_movement_speed;
        float speed_limit = CobblemonFightOrFlight.commonConfig().speed_stat_limit;
        float speed = pokemonEntity.getPokemon().getSpeed();
        float speedMultiplier = Mth.lerp((float)(speed / speed_limit), (float)minimum_movement_speed, (float)maximum_movement_speed);
        float fleeSpeed = 1.3f * speedMultiplier;
        float pursuitSpeed = 1.2f * speedMultiplier;
        goalAdder.accept((Object)pokemonEntity, (Object)2, (Object)new PokemonGoToPosGoal(pokemonEntity, pursuitSpeed));
        goalAdder.accept((Object)pokemonEntity, (Object)3, (Object)new PokemonAttackGoal(pokemonEntity, pursuitSpeed));
        goalAdder.accept((Object)pokemonEntity, (Object)4, (Object)new PokemonAvoidGoal((PathfinderMob)pokemonEntity, PokemonUtils.getAttackRadius() * 3.0f, 1.0f, fleeSpeed));
        goalAdder.accept((Object)pokemonEntity, (Object)4, (Object)new PokemonPanicGoal((PathfinderMob)pokemonEntity, fleeSpeed));
    }

    public static double getFightOrFlightCoefficient(PokemonEntity pokemonEntity) {
        boolean darkLightLevelModifier;
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack) {
            return -100.0f - Math.abs(CobblemonFightOrFlight.commonConfig().neutral_threshold);
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        String speciesName = pokemon.getSpecies().getName().toLowerCase();
        Set pokemonAspects = pokemon.getAspects();
        double height = pokemonEntity.position().y;
        if (CobblemonFightOrFlight.SpeciesNeverAggro(speciesName) || CobblemonFightOrFlight.SpeciesAlwaysFlee(speciesName)) {
            return -100.0f - Math.abs(CobblemonFightOrFlight.commonConfig().neutral_threshold);
        }
        if (CobblemonFightOrFlight.SpeciesAlwaysAggro(speciesName) || CobblemonFightOrFlight.AspectsAlwaysAggro(pokemonAspects) || CobblemonFightOrFlight.BelowAlwaysAggro(height)) {
            return 100.0f + CobblemonFightOrFlight.commonConfig().aggressive_threshold;
        }
        double atkDefDifCoefficient = (double)(pokemon.getAttack() + pokemon.getSpecialAttack() - (pokemon.getDefence() + pokemon.getSpecialDefence())) / (double)pokemon.getLevel() * (double)CobblemonFightOrFlight.commonConfig().aggression_atk_def_dif_base_value;
        double darknessAggressionCoefficient = 0.0;
        double intimidateCoefficient = 0.0;
        String natureName = PokemonUtils.getNatureName(pokemon);
        double natureAggressionCoefficient = Arrays.stream(CobblemonFightOrFlight.commonConfig().more_aggressive_nature).toList().contains(natureName) ? (double)CobblemonFightOrFlight.commonConfig().more_aggressive_nature_multiplier : (Arrays.stream(CobblemonFightOrFlight.commonConfig().aggressive_nature).toList().contains(natureName) ? (double)CobblemonFightOrFlight.commonConfig().aggressive_nature_multiplier : (Arrays.stream(CobblemonFightOrFlight.commonConfig().peaceful_nature).toList().contains(natureName) ? (double)CobblemonFightOrFlight.commonConfig().peaceful_nature_multiplier : (Arrays.stream(CobblemonFightOrFlight.commonConfig().more_peaceful_nature).toList().contains(natureName) ? (double)CobblemonFightOrFlight.commonConfig().more_peaceful_nature_multiplier : 0.0)));
        List pokemons = pokemonEntity.level().getEntitiesOfClass(PokemonEntity.class, AABB.ofSize((Vec3)pokemonEntity.position(), (double)18.0, (double)18.0, (double)18.0), pokemonEntity1 -> pokemonEntity1.getOwner() != null && Arrays.stream(CobblemonFightOrFlight.commonConfig().aggro_reducing_abilities).toList().contains(pokemonEntity1.getPokemon().getAbility().getName()));
        if (!pokemons.isEmpty()) {
            intimidateCoefficient = CobblemonFightOrFlight.commonConfig().aggression_intimidation_base_value;
        }
        ElementalType typePrimary = pokemon.getPrimaryType();
        ElementalType typeSecondary = pokemon.getSecondaryType();
        if (typeSecondary == null) {
            typeSecondary = typePrimary;
        }
        boolean ghostLightLevelModifier = CobblemonFightOrFlight.commonConfig().ghost_light_level_aggro && (typePrimary.getName().equals("ghost") || typeSecondary.getName().equals("ghost"));
        boolean bl = darkLightLevelModifier = CobblemonFightOrFlight.commonConfig().dark_light_level_aggro && (typePrimary.getName().equals("dark") || typeSecondary.getName().equals("dark"));
        if (ghostLightLevelModifier || darkLightLevelModifier) {
            int skyDarken = pokemonEntity.level().getSkyDarken();
            int lightLevel = pokemonEntity.level().getRawBrightness(pokemonEntity.blockPosition(), skyDarken);
            if (lightLevel <= 7) {
                darknessAggressionCoefficient += (double)CobblemonFightOrFlight.commonConfig().aggression_light_level_base_value;
            } else if (lightLevel >= 12) {
                darknessAggressionCoefficient -= (double)CobblemonFightOrFlight.commonConfig().aggression_light_level_base_value;
            }
        }
        double levelAggressionCoefficient = CobblemonFightOrFlight.commonConfig().aggression_level_base_value * CobblemonFightOrFlight.commonConfig().aggression_level_multiplier * (float)pokemon.getLevel() / 100.0f;
        natureAggressionCoefficient = (double)CobblemonFightOrFlight.commonConfig.aggression_nature_base_value * natureAggressionCoefficient;
        double finalResult = levelAggressionCoefficient + atkDefDifCoefficient + natureAggressionCoefficient + darknessAggressionCoefficient + intimidateCoefficient;
        return finalResult;
    }

    public static boolean BelowAlwaysAggro(double height) {
        return height < CobblemonFightOrFlight.commonConfig().always_aggro_below;
    }

    public static boolean AspectsAlwaysAggro(Set<String> pokemonAspects) {
        String[] alwaysAggroFeatures = CobblemonFightOrFlight.commonConfig().always_aggro_aspects;
        HashSet<String> aggroFeatureSet = new HashSet<String>(Arrays.asList(alwaysAggroFeatures));
        for (String aspect : pokemonAspects) {
            if (!aggroFeatureSet.contains(aspect)) continue;
            return true;
        }
        return false;
    }

    public static boolean SpeciesAlwaysAggro(String speciesName) {
        for (String aggroSpecies : CobblemonFightOrFlight.commonConfig().always_aggro) {
            if (!aggroSpecies.equals(speciesName)) continue;
            return true;
        }
        return false;
    }

    public static boolean SpeciesNeverAggro(String speciesName) {
        for (String passiveSpecies : CobblemonFightOrFlight.commonConfig().never_aggro) {
            if (!passiveSpecies.equals(speciesName)) continue;
            return true;
        }
        return false;
    }

    public static boolean SpeciesAlwaysFlee(String speciesName) {
        return Arrays.stream(CobblemonFightOrFlight.commonConfig().always_flee).toList().contains(speciesName);
    }

    public static float AUTO_AGGRO_THRESHOLD() {
        return CobblemonFightOrFlight.commonConfig().aggressive_threshold;
    }

    public static void fromConfigToMoveData() {
        for (String moveName : CobblemonFightOrFlight.moveConfig().taunting_moves) {
            MiscMoveData data = new MiscMoveData("self", "on_use", 1.0f, false, "taunt");
            FOFUtils.registerMoveData(moveName, data);
        }
    }

    public static void PokemonEmoteAngry(Mob mob) {
        double particleSpeed = Math.random();
        double particleAngle = Math.random() * 2.0 * Math.PI;
        double particleXSpeed = Math.cos(particleAngle) * particleSpeed;
        double particleYSpeed = Math.sin(particleAngle) * particleSpeed;
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, mob.position().x, mob.getBoundingBox().maxY, mob.position().z, 1, particleXSpeed, 0.5, particleYSpeed, 1.0);
        } else {
            mob.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, mob.position().x, mob.getBoundingBox().maxY, mob.position().z, particleXSpeed, 0.5, particleYSpeed);
        }
    }
}

