/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import me.rufia.fightorflight.client.model.PokemonSpikeModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PokemonSpikeRenderer
extends EntityRenderer<AbstractPokemonSpike> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/spike.png");
    private final PokemonSpikeModel<AbstractPokemonSpike> model;

    public PokemonSpikeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonSpikeModel(context.bakeLayer(PokemonSpikeModel.LAYER_LOCATION));
    }

    public void render(AbstractPokemonSpike entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Color color = this.getColor(entity);
        int inGroundTick = entity.getInGroundTick();
        poseStack.pushPose();
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float g = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        float h = inGroundTick == -1 ? (float)entity.tickCount + partialTicks : (float)inGroundTick;
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(h * 0.1f)) * 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(h * 0.1f)) * 180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(h * 0.15f)) * 360.0f));
        poseStack.translate(0.0f, -1.5f, 0.0f);
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, f, g);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        int colorCode = FastColor.ARGB32.colorFromFloat((float)0.75f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public Color getColor(AbstractPokemonSpike entity) {
        if (entity.getElementalType() != null) {
            return PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }
        return Color.white;
    }

    public ResourceLocation getTextureLocation(AbstractPokemonSpike entity) {
        return TEXTURE_LOCATION;
    }
}

