/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import me.rufia.fightorflight.client.model.PokemonBulletModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PokemonTracingBulletRenderer
extends EntityRenderer<PokemonTracingBullet> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/tracing_bullet_spark.png");
    private static final RenderType RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)TEXTURE_LOCATION);
    private final PokemonBulletModel<PokemonTracingBullet> model;

    public PokemonTracingBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonBulletModel(context.bakeLayer(ModelLayers.SHULKER_BULLET));
    }

    protected int getBlockLightLevel(PokemonTracingBullet entity, BlockPos pos) {
        return 15;
    }

    public void render(PokemonTracingBullet entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Color color = Color.white;
        if (entity.getElementalType() != null) {
            color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }
        poseStack.pushPose();
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float g = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        float h = (float)entity.tickCount + partialTicks;
        poseStack.translate(0.0f, 0.15f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(h * 0.1f)) * 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(h * 0.1f)) * 180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(h * 0.15f)) * 360.0f));
        poseStack.scale(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, f, g);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        VertexConsumer vertexConsumer2 = buffer.getBuffer(RENDER_TYPE);
        int colorCode = FastColor.ARGB32.colorFromFloat((float)0.75f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(PokemonTracingBullet entity) {
        return TEXTURE_LOCATION;
    }
}

