/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.data.behavior;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.signednumber.SignedFloat;
import me.rufia.fightorflight.utils.signednumber.SignedInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PokemonBehaviorData {
    public static final Map<String, List<PokemonBehaviorData>> behaviorData = new HashMap<String, List<PokemonBehaviorData>>();
    private final String species;
    private final List<String> aspects;
    private final String gender;
    private final List<String> biome;
    private final List<String> ability;
    private final List<String> moves;
    private final List<String> nature;
    private final String levelRequirement;
    private final String healthRatio;
    private final String lightLevel;
    private final String x;
    private final String y;
    private final String z;
    private final String distanceToPlayer;
    private final String type;

    public PokemonBehaviorData(String species, List<String> aspects, String gender, List<String> ability, List<String> move, List<String> nature, List<String> biome, String levelRequirement, String healthRatio, String lightLevel, String x, String y, String z, String distanceToPlayer, String type) {
        this.species = species;
        this.aspects = aspects;
        this.ability = ability;
        this.gender = gender;
        this.moves = move;
        this.nature = nature;
        this.biome = biome;
        this.levelRequirement = levelRequirement;
        this.healthRatio = healthRatio;
        this.lightLevel = lightLevel;
        this.x = x;
        this.y = y;
        this.z = z;
        this.distanceToPlayer = distanceToPlayer;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean check(LivingEntity entity, PokemonEntity pokemonEntity) {
        if (entity != null && pokemonEntity != null) {
            return this.check(pokemonEntity) && this.checkDTP((Entity)entity, pokemonEntity);
        }
        return false;
    }

    public boolean check(PokemonEntity pokemonEntity) {
        if (pokemonEntity != null) {
            return this.check(pokemonEntity.getPokemon()) && this.checkBiome(pokemonEntity) && this.checkLightLevel(pokemonEntity) && this.checkHealthRatio(pokemonEntity) && this.checkMove(pokemonEntity) && this.checkX(pokemonEntity) && this.checkY(pokemonEntity) && this.checkZ(pokemonEntity);
        }
        return false;
    }

    public boolean check(Pokemon pokemon) {
        if (pokemon == null) {
            return false;
        }
        return this.checkItem(this.species, pokemon.getSpecies().getName()) && this.checkItem(this.gender, pokemon.getGender().toString()) && this.checkItem(this.nature, PokemonUtils.getNatureName(pokemon)) && this.checkItem(this.ability, pokemon.getAbility().getName()) && this.checkLevel(pokemon) && this.checkAspects(this.aspects, pokemon.getAspects());
    }

    private boolean checkItem(String targetData, String pokemonData) {
        if (!targetData.isEmpty()) {
            return Objects.equals(targetData.toLowerCase(), pokemonData.toLowerCase());
        }
        return true;
    }

    private boolean checkItem(List<String> targetData, String pokemonData) {
        if (!targetData.isEmpty()) {
            return targetData.contains(pokemonData);
        }
        return true;
    }

    private boolean checkAspects(List<String> requiredAspects, Set<String> pokemonAspects) {
        for (String aspect : requiredAspects) {
            if (pokemonAspects.contains(aspect)) continue;
            return false;
        }
        return true;
    }

    private boolean checkLevel(Pokemon pokemon) {
        SignedInt signedInt = new SignedInt();
        if (signedInt.load(this.levelRequirement)) {
            int pokemonLvl = pokemon.getLevel();
            return signedInt.check(pokemonLvl);
        }
        return this.levelRequirement.isEmpty();
    }

    private boolean checkMove(PokemonEntity pokemonEntity) {
        if (this.moves.isEmpty()) {
            return true;
        }
        MoveSet moveSet = pokemonEntity.getPokemon().getMoveSet();
        for (Move m : moveSet) {
            String moveName = m.getName();
            if (!this.moves.contains(moveName)) continue;
            return true;
        }
        return false;
    }

    private boolean checkHealthRatio(PokemonEntity pokemonEntity) {
        SignedFloat signedFloat = new SignedFloat();
        if (signedFloat.load(this.healthRatio)) {
            float ratio = pokemonEntity.getHealth() / pokemonEntity.getMaxHealth();
            return signedFloat.check(ratio);
        }
        return this.healthRatio.isEmpty();
    }

    private boolean checkLightLevel(PokemonEntity pokemonEntity) {
        SignedInt signedInt = new SignedInt();
        if (signedInt.load(this.lightLevel)) {
            int light = pokemonEntity.level().getRawBrightness(pokemonEntity.blockPosition(), pokemonEntity.level().getSkyDarken());
            return signedInt.check(light);
        }
        return this.lightLevel.isEmpty();
    }

    private boolean checkX(PokemonEntity pokemonEntity) {
        SignedFloat signedFloat = new SignedFloat();
        if (signedFloat.load(this.x)) {
            return signedFloat.check(pokemonEntity.getX());
        }
        return this.x.isEmpty();
    }

    private boolean checkY(PokemonEntity pokemonEntity) {
        SignedFloat signedFloat = new SignedFloat();
        if (signedFloat.load(this.y)) {
            return signedFloat.check(pokemonEntity.getY());
        }
        return this.y.isEmpty();
    }

    private boolean checkZ(PokemonEntity pokemonEntity) {
        SignedFloat signedFloat = new SignedFloat();
        if (signedFloat.load(this.z)) {
            return signedFloat.check(pokemonEntity.getZ());
        }
        return this.z.isEmpty();
    }

    private boolean checkDTP(Entity entity, PokemonEntity pokemonEntity) {
        SignedFloat signedFloat = new SignedFloat();
        if (signedFloat.load(this.distanceToPlayer)) {
            return signedFloat.check(entity.distanceTo((Entity)pokemonEntity));
        }
        return this.distanceToPlayer.isEmpty();
    }

    private boolean checkBiome(PokemonEntity pokemonEntity) {
        return this.biome.contains(pokemonEntity.level().getBiome(pokemonEntity.blockPosition()).getRegisteredName());
    }
}

