/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.data.movedata.movedatas;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Objects;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.effects.FOFEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class StatChangeMoveData
extends MoveData {
    private int stage;

    public StatChangeMoveData(String target, String triggerEvent, float chance, boolean canActivateSheerForce, String name, int stage) {
        super("stat", target, triggerEvent, chance, canActivateSheerForce, name);
        this.stage = stage;
    }

    private boolean isPositive() {
        return this.stage > 0 && this.stage < 7;
    }

    private boolean isNegative() {
        return this.stage < 0 && this.stage > -7;
    }

    @Override
    public void invoke(PokemonEntity pokemonEntity, LivingEntity target) {
        if (!this.chanceTest(pokemonEntity.getRandom(), pokemonEntity) || pokemonEntity.getPokemon().getAbility().getName().equals("sheerforce") && this.canActivateSheerForce()) {
            return;
        }
        LivingEntity finalTarget = this.pickTarget(pokemonEntity, target);
        if (finalTarget == null) {
            return;
        }
        String name = this.getName();
        if (Objects.equals(name, "attack") || Objects.equals(name, "special_attack")) {
            if (this.isPositive()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, this.calculateEffectDuration(pokemonEntity) * 20, this.stage - 1));
            } else if (this.isNegative()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
            }
        } else if (Objects.equals(name, "defense") || Objects.equals(name, "special_defense")) {
            if (this.isPositive()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, this.calculateEffectDuration(pokemonEntity) * 20, this.stage - 1));
            } else if (this.isNegative()) {
                finalTarget.addEffect(new MobEffectInstance(FOFEffects.RESISTANCE_WEAKENED, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
            }
        } else if (Objects.equals(name, "speed")) {
            if (this.isPositive()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, this.calculateEffectDuration(pokemonEntity) * 20, this.stage - 1));
            } else if (this.isNegative()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
            }
        } else if (Objects.equals(name, "all")) {
            if (this.isPositive()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, this.calculateEffectDuration(pokemonEntity) * 20, this.stage - 1));
                finalTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, this.calculateEffectDuration(pokemonEntity) * 20, this.stage - 1));
                finalTarget.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, this.calculateEffectDuration(pokemonEntity) * 20, this.stage - 1));
            } else if (this.isNegative()) {
                finalTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
                finalTarget.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
                finalTarget.addEffect(new MobEffectInstance(FOFEffects.RESISTANCE_WEAKENED, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
            }
        } else if (Objects.equals(name, "accuracy") && this.isNegative()) {
            finalTarget.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, this.calculateEffectDuration(pokemonEntity) * 20, -this.stage - 1));
        }
    }
}

