/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import me.rufia.fightorflight.entity.projectile.PokemonBullet;
import me.rufia.fightorflight.entity.projectile.PokemonFloatingSpike;
import me.rufia.fightorflight.entity.projectile.PokemonSpike;
import me.rufia.fightorflight.entity.projectile.PokemonStickyWeb;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import me.rufia.fightorflight.utils.FOFHeldItemManager;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonMultipliers;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.TypeEffectiveness;
import me.rufia.fightorflight.utils.explosion.FOFExplosion;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PokemonAttackEffect {
    public static SimpleParticleType getParticleFromType(String name) {
        return switch (name) {
            case "fire" -> ParticleTypes.FLAME;
            case "ice" -> ParticleTypes.SNOWFLAKE;
            case "poison" -> ParticleTypes.MYCELIUM;
            case "psychic" -> ParticleTypes.PORTAL;
            case "fairy" -> ParticleTypes.CHERRY_LEAVES;
            case "fighting", "ground", "rock" -> ParticleTypes.POOF;
            case "steel" -> ParticleTypes.WAX_OFF;
            case "ghost" -> ParticleTypes.SOUL;
            case "dark" -> ParticleTypes.SMOKE;
            case "electric" -> ParticleTypes.ELECTRIC_SPARK;
            case "bug" -> ParticleTypes.SPORE_BLOSSOM_AIR;
            case "grass" -> ParticleTypes.COMPOSTER;
            case "dragon" -> ParticleTypes.DRAGON_BREATH;
            case "flying" -> ParticleTypes.SWEEP_ATTACK;
            case "water" -> ParticleTypes.SPLASH;
            case "normal" -> ParticleTypes.CRIT;
            default -> ParticleTypes.CRIT;
        };
    }

    public static Color getColorFromType(String typeName) {
        return switch (typeName) {
            case "fire" -> new Color(230, 40, 41);
            case "ice" -> new Color(63, 216, 255);
            case "poison" -> new Color(145, 65, 203);
            case "psychic" -> new Color(239, 65, 121);
            case "fairy" -> new Color(239, 112, 239);
            case "fighting" -> new Color(255, 128, 0);
            case "steel" -> new Color(96, 161, 184);
            case "ghost" -> new Color(112, 65, 112);
            case "dark" -> new Color(80, 65, 63);
            case "ground" -> new Color(145, 81, 33);
            case "rock" -> new Color(175, 169, 129);
            case "electric" -> new Color(250, 192, 0);
            case "bug" -> new Color(145, 161, 25);
            case "grass" -> new Color(63, 161, 41);
            case "dragon" -> new Color(80, 96, 225);
            case "flying" -> new Color(129, 185, 239);
            case "water" -> new Color(41, 128, 239);
            case "normal" -> new Color(159, 161, 159);
            default -> new Color(68, 104, 94);
        };
    }

    public static SimpleParticleType getParticleFromType(ElementalType type) {
        return PokemonAttackEffect.getParticleFromType(type.getName());
    }

    public static Color getColorFromType(ElementalType type) {
        return PokemonAttackEffect.getColorFromType(type.getName());
    }

    public static Color getColorFromType(Pokemon pokemon) {
        return PokemonAttackEffect.getColorFromType(pokemon.getPrimaryType());
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, Entity target, boolean isSpecial) {
        return PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, target, isSpecial, CobblemonFightOrFlight.moveConfig().base_power, null);
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, Entity target, boolean isSpecial, float movePower, ElementalType type) {
        int attack = isSpecial ? pokemonEntity.getPokemon().getSpecialAttack() : pokemonEntity.getPokemon().getAttack();
        int maxStat = isSpecial ? CobblemonFightOrFlight.commonConfig().maximum_special_attack_stat : CobblemonFightOrFlight.commonConfig().maximum_attack_stat;
        boolean isUsingRangeAttack = PokemonUtils.shouldShoot(pokemonEntity);
        boolean isUsingMeleeAttack = PokemonUtils.shouldMelee(pokemonEntity);
        PokemonMultipliers multipliers = new PokemonMultipliers(pokemonEntity);
        float attackModifier = CobblemonFightOrFlight.commonConfig().max_bonus_from_stat * Mth.sqrt((float)((float)Math.min(attack, maxStat) / (float)maxStat));
        float moveModifier = movePower / 40.0f * CobblemonFightOrFlight.moveConfig().move_power_multiplier;
        float minDmg = isSpecial ? multipliers.getMinimumRangeAttackDamage() : multipliers.getMinimumAttackDamage();
        float maxDmg = isSpecial ? multipliers.getMaximumRangeAttackDamage() : multipliers.getMaximumAttackDamage();
        float sheerForceMultiplier = PokemonUtils.canActivateSheerForce(pokemonEntity) ? 1.3f : 1.0f;
        float multiplier = PokemonAttackEffect.extraDamageFromEntityFeature(pokemonEntity, target, type) * PokemonAttackEffect.getHeldItemDmgMultiplier(pokemonEntity, target) * sheerForceMultiplier * multipliers.getPlayerOwnedDamageMultiplier(isUsingRangeAttack, isUsingMeleeAttack);
        float mobEffectBoost = PokemonAttackEffect.getMobEffectBoost(pokemonEntity);
        PokemonInterface pokemonInterface = (PokemonInterface)pokemonEntity;
        if (pokemonInterface.usingBeam() || pokemonInterface.usingSound() || pokemonInterface.usingMagic()) {
            multiplier *= CobblemonFightOrFlight.moveConfig().indirect_attack_move_power_multiplier;
        }
        float value = Math.min(Math.max(multiplier * (moveModifier * attackModifier + mobEffectBoost), minDmg), maxDmg);
        return value;
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, Entity target, Move move) {
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.info("Null move detected");
            return CobblemonFightOrFlight.commonConfig().minimum_ranged_attack_damage;
        }
        if (PokemonUtils.isStatusMove(move)) {
            return 0.0f;
        }
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        ElementalType primaryType = pokemonEntity.getPokemon().getPrimaryType();
        ElementalType secondaryType = pokemonEntity.getPokemon().getSecondaryType();
        if (secondaryType == null) {
            secondaryType = primaryType;
        }
        float STAB = primaryType.equals(move.getType()) || secondaryType.equals(move.getType()) ? (PokemonUtils.abilityIs(pokemonEntity, "adaptability") ? 2.0f : 1.5f) : 1.0f;
        return PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, target, isSpecial, (float)(move.getPower() * (double)STAB), move.getType());
    }

    protected static float extraDamageFromEntityFeature(PokemonEntity pokemonEntity, Entity target, ElementalType moveType) {
        ElementalType type;
        if (target.level().isClientSide || !(target instanceof LivingEntity)) {
            return 1.0f;
        }
        LivingEntity livingEntity = (LivingEntity)target;
        ElementalType elementalType = type = moveType == null ? pokemonEntity.getPokemon().getPrimaryType() : moveType;
        if (!(livingEntity instanceof PokemonEntity)) {
            if (ElementalTypes.INSTANCE.getWATER().equals(type) && livingEntity.isSensitiveToWater()) {
                return CobblemonFightOrFlight.commonConfig().water_type_super_effective_dmg_multiplier;
            }
            if (ElementalTypes.INSTANCE.getFIRE().equals(type) && livingEntity.fireImmune()) {
                return CobblemonFightOrFlight.commonConfig().fire_type_no_effect_dmg_multiplier;
            }
            if (ElementalTypes.INSTANCE.getICE().equals(type)) {
                if (!livingEntity.canFreeze()) {
                    return CobblemonFightOrFlight.commonConfig().ice_type_no_effect_dmg_multiplier;
                }
                if (livingEntity.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                    return CobblemonFightOrFlight.commonConfig().ice_type_super_effective_dmg_multiplier;
                }
            }
            if (ElementalTypes.INSTANCE.getPOISON().equals(type) && livingEntity.getType().is(EntityTypeTags.UNDEAD)) {
                return CobblemonFightOrFlight.commonConfig().poison_type_no_effect_dmg_multiplier;
            }
        } else {
            PokemonEntity targetPokemon = (PokemonEntity)livingEntity;
            return TypeEffectiveness.getTypeEffectiveness(pokemonEntity, targetPokemon);
        }
        return 1.0f;
    }

    public static int getMobEffectBoost(PokemonEntity pokemonEntity) {
        MobEffectInstance weaknessEffect;
        MobEffectInstance strengthEffect;
        int strengthLevel = 0;
        int weaknessLevel = 0;
        if (pokemonEntity.hasEffect(MobEffects.DAMAGE_BOOST) && (strengthEffect = pokemonEntity.getEffect(MobEffects.DAMAGE_BOOST)) != null) {
            strengthLevel = strengthEffect.getAmplifier() + 1;
        }
        if (pokemonEntity.hasEffect(MobEffects.WEAKNESS) && (weaknessEffect = pokemonEntity.getEffect(MobEffects.WEAKNESS)) != null) {
            weaknessLevel = weaknessEffect.getAmplifier() + 1;
        }
        return strengthLevel * 3 - weaknessLevel * 4;
    }

    public static float getHeldItemDmgMultiplier(PokemonEntity pokemonEntity, Entity target) {
        if (!FOFHeldItemManager.canUseHeldItemDamageInfluencing()) {
            return 1.0f;
        }
        ItemStack heldItem = PokemonUtils.getHeldItem(pokemonEntity);
        Move move = PokemonUtils.getMove(pokemonEntity);
        ElementalType type = null;
        if (move != null) {
            type = move.getType();
        }
        if (heldItem.is((Item)CobblemonItems.LIFE_ORB)) {
            return 1.3f;
        }
        if (move != null) {
            if (DamageCategories.INSTANCE.getPHYSICAL().equals(move.getDamageCategory())) {
                if (heldItem.is((Item)CobblemonItems.MUSCLE_BAND)) {
                    return 1.1f;
                }
                if (heldItem.is((Item)CobblemonItems.CHOICE_BAND)) {
                    return 1.5f;
                }
            } else if (DamageCategories.INSTANCE.getSPECIAL().equals(move.getDamageCategory())) {
                if (heldItem.is((Item)CobblemonItems.WISE_GLASSES)) {
                    return 1.1f;
                }
                if (heldItem.is((Item)CobblemonItems.CHOICE_SPECS)) {
                    return 1.5f;
                }
            }
        }
        if (type != null) {
            float typeEnhancingMultiplier = 1.2f;
            switch (type.getName()) {
                case "fire": {
                    if (!heldItem.is((Item)CobblemonItems.CHARCOAL)) break;
                    return typeEnhancingMultiplier;
                }
                case "ice": {
                    if (!heldItem.is((Item)CobblemonItems.NEVER_MELT_ICE)) break;
                    return typeEnhancingMultiplier;
                }
                case "poison": {
                    if (!heldItem.is((Item)CobblemonItems.POISON_BARB)) break;
                    return typeEnhancingMultiplier;
                }
                case "psychic": {
                    if (!heldItem.is((Item)CobblemonItems.TWISTED_SPOON)) break;
                    return typeEnhancingMultiplier;
                }
                case "fairy": {
                    if (!heldItem.is((Item)CobblemonItems.FAIRY_FEATHER)) break;
                    return typeEnhancingMultiplier;
                }
                case "fighting": {
                    if (!heldItem.is((Item)CobblemonItems.BLACK_BELT)) break;
                    return typeEnhancingMultiplier;
                }
                case "steel": {
                    if (!heldItem.is((Item)CobblemonItems.METAL_COAT)) break;
                    return typeEnhancingMultiplier;
                }
                case "ghost": {
                    if (!heldItem.is((Item)CobblemonItems.SPELL_TAG)) break;
                    return typeEnhancingMultiplier;
                }
                case "dark": {
                    if (!heldItem.is((Item)CobblemonItems.BLACK_GLASSES)) break;
                    return typeEnhancingMultiplier;
                }
                case "ground": {
                    if (!heldItem.is((Item)CobblemonItems.SOFT_SAND)) break;
                    return typeEnhancingMultiplier;
                }
                case "rock": {
                    if (!heldItem.is((Item)CobblemonItems.HARD_STONE)) break;
                    return typeEnhancingMultiplier;
                }
                case "electric": {
                    if (!heldItem.is((Item)CobblemonItems.MAGNET)) break;
                    return typeEnhancingMultiplier;
                }
                case "bug": {
                    if (!heldItem.is((Item)CobblemonItems.SILVER_POWDER)) break;
                    return typeEnhancingMultiplier;
                }
                case "grass": {
                    if (!heldItem.is((Item)CobblemonItems.MIRACLE_SEED)) break;
                    return typeEnhancingMultiplier;
                }
                case "dragon": {
                    if (!heldItem.is((Item)CobblemonItems.DRAGON_FANG)) break;
                    return typeEnhancingMultiplier;
                }
                case "flying": {
                    if (!heldItem.is((Item)CobblemonItems.SHARP_BEAK)) break;
                    return typeEnhancingMultiplier;
                }
                case "water": {
                    if (!heldItem.is((Item)CobblemonItems.MYSTIC_WATER)) break;
                    return typeEnhancingMultiplier;
                }
                case "normal": {
                    if (!heldItem.is((Item)CobblemonItems.SILK_SCARF)) break;
                    return typeEnhancingMultiplier;
                }
            }
        }
        return 1.0f;
    }

    public static boolean canChangeMove(PokemonEntity pokemonEntity) {
        ItemStack itemStack = PokemonUtils.getHeldItem(pokemonEntity);
        return !itemStack.is((Item)CobblemonItems.CHOICE_BAND) && !itemStack.is((Item)CobblemonItems.CHOICE_SCARF) && !itemStack.is((Item)CobblemonItems.CHOICE_SPECS);
    }

    protected static void calculateTypeEffect(PokemonEntity pokemonEntity, Entity hurtTarget, String typeName, int pkmLevel) {
        if (PokemonUtils.isSheerForce(pokemonEntity)) {
            return;
        }
        if (hurtTarget instanceof LivingEntity) {
            LivingEntity livingHurtTarget = (LivingEntity)hurtTarget;
            int effectStrength = Math.max(pkmLevel / 10, 1);
            switch (typeName) {
                case "fire": {
                    livingHurtTarget.setRemainingFireTicks(effectStrength * 20);
                    break;
                }
                case "ice": {
                    livingHurtTarget.setTicksFrozen(livingHurtTarget.getTicksFrozen() + effectStrength * 30);
                    break;
                }
                case "poison": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.POISON, effectStrength * 20, 0), (Entity)pokemonEntity);
                    break;
                }
                case "psychic": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.LEVITATION, effectStrength * 20, 0), (Entity)pokemonEntity);
                    break;
                }
                case "fairy": 
                case "fighting": 
                case "steel": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, effectStrength * 20, 0), (Entity)pokemonEntity);
                    break;
                }
                case "ghost": 
                case "dark": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.DARKNESS, effectStrength * 25, 0), (Entity)pokemonEntity);
                    break;
                }
                case "ground": 
                case "rock": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, effectStrength * 25, 0), (Entity)pokemonEntity);
                    break;
                }
                case "electric": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectStrength * 25, 0), (Entity)pokemonEntity);
                    break;
                }
                case "bug": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.HUNGER, effectStrength * 25, 0), (Entity)pokemonEntity);
                    break;
                }
                case "grass": {
                    pokemonEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, effectStrength * 40, 0), (Entity)pokemonEntity);
                    break;
                }
                case "water": {
                    livingHurtTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, (effectStrength + 2) * 25, 0), (Entity)pokemonEntity);
                    break;
                }
            }
        }
    }

    public static void applyTypeEffect(PokemonEntity pokemonEntity, Entity hurtTarget, String typeName) {
        if (pokemonEntity == null) {
            return;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        int pkmLevel = pokemon.getLevel();
        PokemonAttackEffect.calculateTypeEffect(pokemonEntity, hurtTarget, typeName, pkmLevel);
    }

    public static void applyTypeEffect(PokemonEntity pokemonEntity, Entity hurtTarget) {
        if (pokemonEntity == null) {
            return;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        int pkmLevel = pokemon.getLevel();
        String primaryType = pokemon.getPrimaryType().getName();
        PokemonAttackEffect.calculateTypeEffect(pokemonEntity, hurtTarget, primaryType, pkmLevel);
    }

    public static void applyOnHitVisualEffect(PokemonEntity pokemonEntity, Entity hurtTarget, Move move) {
        if (move == null) {
            return;
        }
        String moveName = move.getName();
        int particleAmount = 4;
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().self_angry_moves).toList().contains(moveName);
        boolean b2 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().target_soul_fire_moves).toList().contains(moveName);
        boolean b3 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().target_soul_moves).toList().contains(moveName);
        boolean b4 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().slicing_moves).toList().contains(moveName);
        boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(moveName);
        if (b1) {
            PokemonUtils.makeParticle(particleAmount, (Entity)pokemonEntity, ParticleTypes.ANGRY_VILLAGER);
        }
        if (b2) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, ParticleTypes.SOUL_FIRE_FLAME);
        }
        if (b3) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, ParticleTypes.SOUL);
        }
        if (b4) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, ParticleTypes.SWEEP_ATTACK);
        }
        if (b5) {
            PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, hurtTarget);
        }
        if (hurtTarget instanceof PokemonEntity) {
            PokemonEntity targetPokemon = (PokemonEntity)hurtTarget;
            float typeEffectivenessMultiplier = TypeEffectiveness.getTypeEffectiveness(pokemonEntity, targetPokemon);
            if (typeEffectivenessMultiplier >= 1.3f) {
                PokemonUtils.makeParticle(particleAmount, hurtTarget, ParticleTypes.WAX_ON);
            } else if (typeEffectivenessMultiplier < 1.0f) {
                PokemonUtils.makeParticle(particleAmount, hurtTarget, ParticleTypes.SCRAPE);
            }
        }
    }

    public static void makeMagicAttackParticle(PokemonEntity pokemonEntity, Entity target) {
        int particleAmount = 8;
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        if (move == null) {
            return;
        }
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, (Entity)pokemonEntity, move.getType().getName());
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, target, move.getType().getName());
    }

    public static void makeTypeEffectParticle(int particleAmount, Entity entity, String typeName) {
        if (typeName == null) {
            return;
        }
        PokemonUtils.makeParticle(particleAmount, entity, PokemonAttackEffect.getParticleFromType(typeName));
    }

    public static void applyOnUseEffect(PokemonEntity pokemonEntity, LivingEntity hurtTarget, Move move) {
        Level level = hurtTarget.level();
        if (move == null || level.isClientSide) {
            return;
        }
        if (CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.isOnUse()) continue;
                data.invoke(pokemonEntity, hurtTarget);
            }
        }
    }

    public static void applyPostEffect(PokemonEntity pokemonEntity, LivingEntity hurtTarget, Move move, boolean targetIsHurt) {
        String abilityName;
        Level level = hurtTarget.level();
        if (move == null || level.isClientSide) {
            return;
        }
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().switch_moves).toList().contains(move.getName());
        boolean b2 = Arrays.stream(CobblemonFightOrFlight.moveConfig().explosive_moves).toList().contains(move.getName());
        boolean b3 = Arrays.stream(CobblemonFightOrFlight.moveConfig().recoil_moves_allHP).toList().contains(move.getName());
        boolean b4 = Arrays.stream(CobblemonFightOrFlight.moveConfig().hp_draining_moves_50).toList().contains(move.getName());
        boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().hp_draining_moves_75).toList().contains(move.getName());
        boolean b6 = FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.LIFE_ORB);
        float dmg = PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (Entity)hurtTarget, move);
        if (b1) {
            PokemonAttackEffect.pokemonRecallWithAnimation(pokemonEntity);
        }
        if (b2) {
            PokemonAttackEffect.pokemonExplode(pokemonEntity, level);
        }
        if (b3) {
            PokemonAttackEffect.pokemonRecoilSelf(pokemonEntity, 1.0f);
        }
        if (b4 || b5) {
            boolean hasBigRoot = FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.BIG_ROOT);
            float percent = (b4 ? 0.5f : 0.75f) * (hasBigRoot ? 1.3f : 1.0f);
            pokemonEntity.heal(dmg * percent);
        }
        if (b6 && !(abilityName = pokemonEntity.getPokemon().getAbility().getName()).equals("sheerforce") && !abilityName.equals("magicguard")) {
            PokemonAttackEffect.pokemonRecoilSelf(pokemonEntity, 0.1f);
        }
        if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, (Entity)hurtTarget, move.getType().getName());
        }
        if (CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.isOnHit() || !targetIsHurt) continue;
                data.invoke(pokemonEntity, hurtTarget);
            }
        }
        if (!PokemonUtils.isSheerForce(pokemonEntity) && FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.SHELL_BELL)) {
            float healAmount = dmg / 8.0f;
            pokemonEntity.heal(healAmount > 1.0f ? healAmount : 1.0f);
        }
    }

    public static void pokemonRecallWithAnimation(PokemonEntity pokemonEntity) {
        if (pokemonEntity.getOwner() != null) {
            pokemonEntity.recallWithAnimation();
        }
    }

    protected static void addProjectileEntity(PokemonEntity pokemonEntity, LivingEntity target, AbstractPokemonProjectile projectile, Move move) {
        projectile.setElementalType(move.getType().getName());
        projectile.setDamage(PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (Entity)target, move));
        pokemonEntity.level().addFreshEntity((Entity)projectile);
    }

    protected static void addProjectileEntity(PokemonEntity pokemonEntity, LivingEntity target, AbstractPokemonProjectile projectile) {
        projectile.setElementalType(pokemonEntity.getPokemon().getPrimaryType().getName());
        projectile.setDamage(PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (Entity)target, true));
        pokemonEntity.level().addFreshEntity((Entity)projectile);
    }

    protected static void shootProjectileEntity(PokemonEntity pokemonEntity, LivingEntity target, AbstractPokemonProjectile projectile) {
        double d = target.getX() - pokemonEntity.getX();
        double e = target.getY(0.5) - projectile.getY();
        double f = target.getZ() - pokemonEntity.getZ();
        float velocity = 1.6f;
        projectile.accurateShoot(d, e, f, velocity, 0.1f);
    }

    public static void pokemonPerformRangedAttack(PokemonEntity pokemonEntity, LivingEntity target) {
        if (pokemonEntity == null || target == null) {
            return;
        }
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
        if (move != null) {
            String moveName = move.getName();
            Random rand = new Random();
            boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName);
            boolean b2 = Arrays.stream(CobblemonFightOrFlight.moveConfig().multiple_bullet_moves).toList().contains(moveName);
            boolean b3 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_tracing_bullet_moves).toList().contains(moveName);
            boolean b4 = Arrays.stream(CobblemonFightOrFlight.moveConfig().multiple_tracing_bullet_moves).toList().contains(moveName);
            boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(moveName);
            boolean b6 = PokemonUtils.isExplosiveMove(moveName);
            boolean b7 = Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(moveName);
            boolean b8 = Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(moveName);
            if (b3 || b4) {
                for (int i = 0; i < (b3 ? 1 : rand.nextInt(3) + 1); ++i) {
                    PokemonTracingBullet bullet = new PokemonTracingBullet(pokemonEntity.level(), (LivingEntity)pokemonEntity, (Entity)target, pokemonEntity.getDirection().getAxis());
                    PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            } else if (b1 || b2) {
                for (int i = 0; i < (b1 ? 1 : rand.nextInt(3) + 1); ++i) {
                    PokemonBullet bullet = new PokemonBullet(pokemonEntity.level(), (LivingEntity)pokemonEntity);
                    PokemonAttackEffect.shootProjectileEntity(pokemonEntity, target, bullet);
                    PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            } else if (b5 || b7 || b8) {
                if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (Entity)target)) {
                    boolean success = target.hurt(pokemonEntity.damageSources().indirectMagic((Entity)pokemonEntity, (Entity)pokemonEntity), PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (Entity)target, move));
                    PokemonUtils.setHurtByPlayer(pokemonEntity, (Entity)target);
                    PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, (Entity)target, move);
                    PokemonAttackEffect.applyPostEffect(pokemonEntity, target, move, success);
                }
            } else if (!b6) {
                PokemonArrow bullet = new PokemonArrow(pokemonEntity.level(), (LivingEntity)pokemonEntity, (Entity)target);
                PokemonAttackEffect.shootProjectileEntity(pokemonEntity, target, bullet);
                PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet, move);
            }
            if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                PokemonAttackEffect.applyOnUseEffect(pokemonEntity, target, move);
            }
        } else {
            PokemonArrow bullet = new PokemonArrow(pokemonEntity.level(), (LivingEntity)pokemonEntity, (Entity)target);
            PokemonAttackEffect.shootProjectileEntity(pokemonEntity, target, bullet);
            PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet);
        }
    }

    public static void spreadSpikes(PokemonEntity pokemonEntity, String type) {
        if (pokemonEntity == null || type == null || !CobblemonFightOrFlight.moveConfig().enable_spikes) {
            return;
        }
        RandomSource rand = pokemonEntity.level().random;
        int count = rand.nextIntBetweenInclusive(6, 8);
        double horizontal = 1.0f + pokemonEntity.getBbWidth() / 2.0f;
        float velocity = 0.8f;
        LivingEntity livingEntity = pokemonEntity.getTarget();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity target = livingEntity;
            double x = target.getX() - pokemonEntity.getX();
            double z = target.getZ() - pokemonEntity.getZ();
            PokemonAttackEffect.spreadFanShape(x, z, count, 3, pokemonEntity, type, rand, velocity);
        } else {
            PokemonAttackEffect.spreadAround(horizontal, count, pokemonEntity, type, rand, velocity);
        }
    }

    protected static void spreadFanShape(double xf, double zf, int count, int level, PokemonEntity pokemonEntity, String type, RandomSource rand, float velocity) {
        float length = Mth.sqrt((float)((float)(xf * xf + zf * zf)));
        if (level > count) {
            level = 1;
        }
        ArrayList<Integer> lis = new ArrayList<Integer>();
        int tmp = count;
        for (int i = 0; i < level - 1; ++i) {
            int max = count / level;
            int n = rand.nextIntBetweenInclusive(1, max);
            lis.add(n);
            tmp -= n;
        }
        lis.add(tmp);
        for (int n = 0; n < level; ++n) {
            for (int i = 0; i < (Integer)lis.get(n); ++i) {
                float mul = (1.0f + (float)n) / length;
                float rad = FOFUtils.toRad(45.0 * ((double)rand.nextFloat() - 0.5));
                AbstractPokemonSpike spike = PokemonAttackEffect.createSpike(pokemonEntity.level(), (LivingEntity)pokemonEntity, type);
                spike.accurateShoot((double)mul * (xf * (double)Mth.cos((float)rad) - zf * (double)Mth.sin((float)rad)), 0.0, (double)mul * (xf * (double)Mth.sin((float)rad) + zf * (double)Mth.cos((float)rad)), velocity, 0.1f);
                pokemonEntity.level().addFreshEntity((Entity)spike);
            }
        }
    }

    protected static void spreadAround(double r, int count, PokemonEntity pokemonEntity, String type, RandomSource rand, float velocity) {
        for (int i = 0; i < count; ++i) {
            AbstractPokemonSpike spike = PokemonAttackEffect.createSpike(pokemonEntity.level(), (LivingEntity)pokemonEntity, type);
            if (spike == null) {
                return;
            }
            float rad = FOFUtils.toRad((double)(360.0f / (float)count) * ((double)i + ((double)rand.nextFloat() - 0.5) / 2.0));
            spike.accurateShoot(r * (double)Mth.cos((float)rad), 0.0, r * (double)Mth.sin((float)rad), velocity, 0.1f);
            pokemonEntity.level().addFreshEntity((Entity)spike);
        }
    }

    protected static AbstractPokemonSpike createSpike(Level level, LivingEntity shooter, String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "spikes": {
                PokemonSpike spike = new PokemonSpike(level, shooter);
                spike.setElementalType("ground");
                return spike;
            }
            case "toxic_spikes": {
                PokemonSpike spike = new PokemonSpike(level, shooter);
                spike.setElementalType("poison");
                return spike;
            }
            case "stealth_rock": {
                PokemonFloatingSpike spike = new PokemonFloatingSpike(level, shooter);
                spike.setElementalType("rock");
                return spike;
            }
            case "sticky_web": {
                PokemonStickyWeb spike = new PokemonStickyWeb(level, shooter);
                spike.setElementalType("bug");
                return spike;
            }
        }
        return null;
    }

    public static void pokemonExplode(PokemonEntity entity, Level level) {
        if (!level.isClientSide) {
            FOFExplosion explosion = FOFExplosion.createExplosion((Entity)entity, entity, entity.getX(), entity.getY(), entity.getZ(), true, false);
            if (explosion != null) {
                explosion.explode();
                explosion.finalizeExplosion();
            } else {
                CobblemonFightOrFlight.LOGGER.warn("Failed to create the explosion");
            }
        }
    }

    public static void dealAoEDamage(PokemonEntity pokemonEntity, Entity centerEntity, boolean shouldHurtAlly, boolean decreaseOverDistance, boolean hasDirectContact) {
        if (pokemonEntity == null) {
            return;
        }
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.warn("No move for aoe.");
            return;
        }
        double radius = PokemonAttackEffect.getAoERadius(pokemonEntity, move);
        List list = centerEntity.level().getEntitiesOfClass(LivingEntity.class, centerEntity.getBoundingBox().inflate(radius - (double)(centerEntity.getBbWidth() / 2.0f)));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            float distance;
            LivingEntity livingEntity = (LivingEntity)it.next();
            if (centerEntity.distanceToSqr((Entity)livingEntity) > 25.0 || livingEntity == pokemonEntity || !shouldHurtAlly || !PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, livingEntity)) continue;
            float dmgMultiplier = decreaseOverDistance ? ((distance = centerEntity.distanceTo((Entity)livingEntity)) < CobblemonFightOrFlight.moveConfig().min_AoE_radius ? 1.0f : CobblemonFightOrFlight.moveConfig().min_AoE_damage_multiplier) : CobblemonFightOrFlight.moveConfig().min_AoE_damage_multiplier;
            DamageSource dmgSource = hasDirectContact ? centerEntity.damageSources().mobAttack((LivingEntity)pokemonEntity) : centerEntity.damageSources().indirectMagic((Entity)pokemonEntity, (Entity)pokemonEntity);
            boolean bl = livingEntity.hurt(dmgSource, PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (Entity)livingEntity, move) * dmgMultiplier);
            if (!bl) continue;
            PokemonUtils.setHurtByPlayer(pokemonEntity, (Entity)livingEntity);
            PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, (Entity)livingEntity, move);
            PokemonAttackEffect.makeTypeEffectParticle(10, (Entity)livingEntity, move.getType().getName());
        }
        return;
    }

    public static void dealAoEDamage(PokemonEntity pokemonEntity, Entity centerEntity, boolean shouldHurtAlly, boolean hasDirectContact) {
        if (pokemonEntity != null) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                PokemonAttackEffect.dealAoEDamage(pokemonEntity, centerEntity, shouldHurtAlly, true, hasDirectContact);
            } else {
                CobblemonFightOrFlight.LOGGER.warn("[FOF]:Failed to get move for aoe damage");
            }
        }
    }

    public static void pokemonRecoilSelf(PokemonEntity pokemonEntity, float percent) {
        float maxHealth;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float curHealth = pokemonEntity.getHealth();
        float health = curHealth - (maxHealth = pokemonEntity.getMaxHealth()) * percent;
        if (health > 0.0f) {
            pokemonEntity.setHealth(curHealth);
        } else {
            pokemonEntity.setHealth(0.0f);
        }
        PokemonUtils.entityHpToPokemonHp(pokemonEntity, maxHealth * percent, false);
        if (pokemonEntity.getHealth() == 0.0f) {
            pokemon.setCurrentHealth(0);
        }
    }

    public static float getAoERadius(PokemonEntity entity, Move move) {
        Pokemon pokemon = entity.getPokemon();
        boolean isSpecial = move.getDamageCategory().equals(DamageCategories.INSTANCE.getSPECIAL());
        int stat = isSpecial ? pokemon.getSpecialAttack() : pokemon.getAttack();
        int requiredStat = isSpecial ? CobblemonFightOrFlight.commonConfig().maximum_special_attack_stat : CobblemonFightOrFlight.commonConfig().maximum_attack_stat;
        return Math.min(Mth.lerp((float)((float)stat / (float)requiredStat), (float)CobblemonFightOrFlight.moveConfig().min_AoE_radius, (float)CobblemonFightOrFlight.moveConfig().max_AoE_radius), CobblemonFightOrFlight.moveConfig().max_AoE_radius);
    }

    public static int calculateAttackTime(PokemonEntity pokemonEntity, double distance) {
        if (pokemonEntity == null) {
            return -1;
        }
        boolean isMelee = PokemonUtils.shouldMelee(pokemonEntity);
        float attackSpeedModifier = Math.max(0.1f, 1.0f - pokemonEntity.getSpeed() / (float)CobblemonFightOrFlight.commonConfig().speed_stat_limit);
        float f = (isMelee ? 0.2f : (float)Math.sqrt(distance) / PokemonUtils.getAttackRadius()) * attackSpeedModifier;
        if (isMelee) {
            return Mth.floor((float)(20.0f * Mth.lerp((float)f, (float)CobblemonFightOrFlight.commonConfig().minimum_melee_attack_interval, (float)CobblemonFightOrFlight.commonConfig().maximum_melee_attack_interval)));
        }
        return Mth.floor((float)(20.0f * Mth.lerp((float)f, (float)CobblemonFightOrFlight.commonConfig().minimum_ranged_attack_interval, (float)CobblemonFightOrFlight.commonConfig().maximum_ranged_attack_interval)));
    }

    public static void refreshAttackTime(PokemonEntity pokemonEntity, int attackTime) {
        ((PokemonInterface)pokemonEntity).setAttackTime(attackTime);
        ((PokemonInterface)pokemonEntity).setMaxAttackTime(attackTime);
    }

    public static void resetAttackTime(PokemonEntity pokemonEntity, double distance) {
        int attackTime = PokemonAttackEffect.calculateAttackTime(pokemonEntity, distance);
        PokemonAttackEffect.refreshAttackTime(pokemonEntity, attackTime);
    }

    public static boolean pokemonAttack(PokemonEntity pokemonEntity, Entity hurtTarget) {
        LivingEntity livingEntity;
        float hurtDamage;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float hurtKnockback = 1.0f;
        Move move = PokemonUtils.getMeleeMove(pokemonEntity);
        if (move != null) {
            boolean b1 = PokemonUtils.isExplosiveMove(move.getName());
            hurtDamage = b1 ? 0.0f : PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, hurtTarget, move);
            if (hurtTarget instanceof LivingEntity) {
                livingEntity = (LivingEntity)hurtTarget;
                PokemonAttackEffect.makeTypeEffectParticle(10, (Entity)livingEntity, move.getType().getName());
                PokemonUtils.updateMoveEvolutionProgress(pokemon, move.getTemplate());
                if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                    PokemonAttackEffect.applyOnUseEffect(pokemonEntity, livingEntity, move);
                }
            }
        } else {
            if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
                PokemonAttackEffect.applyTypeEffect(pokemonEntity, hurtTarget);
            }
            PokemonAttackEffect.makeTypeEffectParticle(6, hurtTarget, pokemonEntity.getPokemon().getPrimaryType().getName());
            hurtDamage = PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, hurtTarget, false);
        }
        PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, hurtTarget, move);
        PokemonUtils.setHurtByPlayer(pokemonEntity, hurtTarget);
        boolean flag = hurtTarget.hurt(pokemonEntity.level().damageSources().mobAttack((LivingEntity)pokemonEntity), hurtDamage);
        if (flag) {
            if (hurtTarget instanceof LivingEntity) {
                livingEntity = (LivingEntity)hurtTarget;
                if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
                    pokemonEntity.setDeltaMovement(pokemonEntity.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                }
                if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                    PokemonAttackEffect.applyPostEffect(pokemonEntity, livingEntity, move, true);
                }
                livingEntity.knockback(CobblemonFightOrFlight.commonConfig().activate_type_effect ? (double)(hurtKnockback * 0.5f) : 0.5, (double)Mth.sin((float)(pokemonEntity.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(pokemonEntity.getYRot() * ((float)Math.PI / 180)))));
            }
            pokemonEntity.setLastHurtMob(hurtTarget);
        }
        return flag;
    }

    public static boolean shouldHurtAllyMob(PokemonEntity pokemonEntity, LivingEntity target) {
        if (pokemonEntity == null || target == null) {
            return true;
        }
        boolean b = false;
        LivingEntity livingEntity = pokemonEntity.getOwner();
        if (livingEntity instanceof Player) {
            Player owner = (Player)livingEntity;
            if (CobblemonFightOrFlight.commonConfig().pvp_immunity) {
                b = target instanceof Player;
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_team) {
                if (target instanceof TamableAnimal) {
                    TamableAnimal tamableAnimal = (TamableAnimal)target;
                    b = Objects.equals(owner, tamableAnimal.getOwner());
                } else {
                    boolean bl = b = b || Objects.equals(owner.getTeam(), target.getTeam()) && owner.getTeam() != null;
                }
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_owner) {
                b = b || owner.equals((Object)target);
            }
            return !b;
        }
        return true;
    }

    public static boolean shouldBeHurtByAllyMob(PokemonEntity pokemonEntity, LivingEntity attacker) {
        if (pokemonEntity == null || attacker == null) {
            return true;
        }
        LivingEntity livingEntity = pokemonEntity.getOwner();
        if (livingEntity instanceof Player) {
            Player owner = (Player)livingEntity;
            if (CobblemonFightOrFlight.commonConfig().pvp_immunity) {
                return !(attacker instanceof Player);
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_team) {
                return !Objects.equals(owner.getTeam(), attacker.getTeam());
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_owner) {
                return !owner.equals((Object)attacker);
            }
        }
        return true;
    }
}

