/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Objects;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class PokemonSpike
extends AbstractPokemonSpike {
    public PokemonSpike(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public PokemonSpike(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractPokemonProjectile>)((EntityType)EntityFightOrFlight.SPIKE.get()), level);
        this.activated = false;
        this.life = 0;
        this.inGround = false;
        this.initPosition(shooter);
    }

    @Override
    protected void hurtEntity(LivingEntity target) {
        PokemonEntity pokemonEntity;
        Entity entity = this.getOwner();
        if (entity instanceof PokemonEntity && PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity = (PokemonEntity)entity, target)) {
            if (Objects.equals(this.getElementalType(), "poison")) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0), (Entity)pokemonEntity);
            } else {
                DamageSource damageSource = this.damageSources().indirectMagic((Entity)this, (Entity)pokemonEntity);
                if (target.hurt(damageSource, CobblemonFightOrFlight.moveConfig().spike_basic_damage)) {
                    pokemonEntity.setLastHurtByMob((LivingEntity)pokemonEntity);
                    PokemonUtils.setHurtByPlayer(pokemonEntity, (Entity)target);
                }
            }
        }
    }
}

