/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Arrays;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;

public class PokemonPanicGoal
extends PanicGoal {
    private LivingEntity lastCaughtByMob;
    private int lastCaughtByMobTimestamp;

    public PokemonPanicGoal(PathfinderMob mob, double speedModifier) {
        super(mob, speedModifier);
    }

    protected boolean shouldPanic() {
        PokemonEntity pokemonEntity = (PokemonEntity)this.mob;
        if (pokemonEntity.isBusy()) {
            return false;
        }
        if (PokemonUtils.shouldStopRunningAfterHurt(pokemonEntity) && pokemonEntity.getMaxHealth() != pokemonEntity.getHealth()) {
            return false;
        }
        if (this.mob.isOnFire() || this.mob.isFreezing()) {
            return true;
        }
        if (this.mob.getLastHurtByMob() != null) {
            return !(CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) > (double)CobblemonFightOrFlight.commonConfig().neutral_threshold) || Arrays.stream(CobblemonFightOrFlight.commonConfig().always_flee).toList().contains(pokemonEntity.getPokemon().getSpecies().getName().toLowerCase());
        }
        return false;
    }
}

