/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals.targeting;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import java.util.Objects;
import java.util.function.Predicate;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.compat.LivelierPokemonCompat;
import me.rufia.fightorflight.utils.TargetingWhitelist;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import org.jetbrains.annotations.Nullable;

public class PokemonProactiveTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    public float safeDistanceSqr;

    public PokemonProactiveTargetGoal(Mob mob, Class<T> targetType, float safeDistanceSqr, int randomInterval, boolean mustSee, boolean mustReach, @Nullable Predicate<LivingEntity> targetPredicate) {
        super(mob, targetType, randomInterval, mustSee, mustReach, targetPredicate);
        this.safeDistanceSqr = safeDistanceSqr;
    }

    public boolean canUse() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_proactive) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)this.mob;
        if (pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
            return false;
        }
        if (!pokemonEntity.getPokemon().isPlayerOwned()) {
            return false;
        }
        return super.canUse();
    }

    protected void findTarget() {
        super.findTarget();
        Mob mob = this.mob;
        if (!(mob instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)mob;
        if (this.target != null) {
            NeutralMob neutralMob;
            LivingEntity mobTarget;
            LivingEntity livingEntity;
            if (this.target.distanceToSqr((Entity)this.mob) > (double)this.safeDistanceSqr) {
                this.target = null;
            } else if (TargetingWhitelist.getWhitelist(pokemonEntity).contains(this.target.getEncodeId())) {
                this.target = null;
            } else if (!(!(this.target instanceof Creeper) || CobblemonFightOrFlight.commonConfig().do_pokemon_defend_creeper_proactive || CobblemonFightOrFlight.commonConfig().do_cat_pokemon_defend_creeper_proactive && LivelierPokemonCompat.isLoaded() && LivelierPokemonCompat.getCats().contains(pokemonEntity.getPokemon().getSpecies().getName()))) {
                this.target = null;
            } else if (CobblemonFightOrFlight.commonConfig().pokemon_proactive_level == 1 && (livingEntity = this.target) instanceof NeutralMob && !Objects.equals(mobTarget = (neutralMob = (NeutralMob)livingEntity).getTarget(), pokemonEntity.getOwner())) {
                this.target = null;
            }
        }
    }
}

