/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.net.handler;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import dev.architectury.networking.NetworkManager;
import me.rufia.fightorflight.item.ItemFightOrFlight;
import me.rufia.fightorflight.net.NetworkPacketHandler;
import me.rufia.fightorflight.net.packet.PokeStaffCmdPacket;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class PokeStaffCmdHandler<T extends PokeStaffCmdPacket>
implements NetworkPacketHandler<T> {
    protected ItemStack getStack(Player player) {
        if (player.getMainHandItem().is((Item)ItemFightOrFlight.POKESTAFF.get())) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().is((Item)ItemFightOrFlight.POKESTAFF.get())) {
            return player.getOffhandItem();
        }
        return null;
    }

    protected void handlePacket(T packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        int slot = ((PokeStaffCmdPacket)packet).getSlot();
        if (player instanceof ServerPlayer) {
            PokemonState state;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Pokemon pokemon = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer).get(slot);
            if (pokemon != null && !((state = pokemon.getState()) instanceof ShoulderedState) && state instanceof ActivePokemonState) {
                ActivePokemonState activePokemonState = (ActivePokemonState)state;
                PokemonEntity pokemonEntity = activePokemonState.getEntity();
                this.processCommand(pokemonEntity, player, packet);
            }
        }
    }

    protected void processCommand(PokemonEntity pokemonEntity, Player player, T packet) {
        if (pokemonEntity != null) {
            ItemStack stack = this.getStack(player);
            if (stack == null) {
                if (PokemonUtils.shouldCheckPokeStaff()) {
                    return;
                }
            } else {
                this.editStaff(stack, packet);
            }
            this.finalProcess(pokemonEntity, player, packet);
        }
    }

    protected abstract void editStaff(ItemStack var1, T var2);

    protected abstract void finalProcess(PokemonEntity var1, Player var2, T var3);
}

