/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.platform.neoforge;

import net.caffeinemc.mods.sodium.client.services.SodiumModelData;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.SodiumAuxiliaryLightManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LevelSlice.class})
public abstract class LevelSliceMixin
implements BlockAndTintGetter {
    @Shadow
    @Final
    private SodiumAuxiliaryLightManager[] auxLightManager;
    @Shadow
    @Final
    private ClientLevel level;
    @Shadow
    private int originBlockX;
    @Shadow
    private int originBlockY;
    @Shadow
    private int originBlockZ;

    @Shadow
    public static int getLocalSectionIndex(int sectionX, int sectionY, int sectionZ) {
        throw new IllegalStateException("Not shadowed!");
    }

    @Shadow
    public SodiumModelData getPlatformModelData(BlockPos pos) {
        throw new IllegalStateException("Not shadowed!");
    }

    public ModelData getModelData(BlockPos pos) {
        SodiumModelData modelData = this.getPlatformModelData(pos);
        return modelData != null ? (ModelData)modelData : null;
    }

    @Nullable
    public AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        int relChunkX = pos.x - (this.originBlockX >> 4);
        int relChunkZ = pos.z - (this.originBlockZ >> 4);
        return (AuxiliaryLightManager)this.auxLightManager[LevelSliceMixin.getLocalSectionIndex(relChunkX, 0, relChunkZ)];
    }

    @Nullable
    public AuxiliaryLightManager getAuxLightManager(BlockPos pos) {
        int relBlockX = pos.getX() - this.originBlockX;
        int relBlockY = pos.getY() - this.originBlockY;
        int relBlockZ = pos.getZ() - this.originBlockZ;
        return (AuxiliaryLightManager)this.auxLightManager[LevelSliceMixin.getLocalSectionIndex(relBlockX >> 4, relBlockY >> 4, relBlockZ >> 4)];
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.level.getShade(normalX, normalY, normalZ, shade);
    }
}

