/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.holders;

import com.fej1fun.potentials.capabilities.types.NoProviderBlockCapabilityHolder;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import com.fej1fun.potentials.neoforge.energy.NeoForgeEnergyStorage;
import com.fej1fun.potentials.neoforge.energy.UniversalIEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyBlockHolder
implements NoProviderBlockCapabilityHolder<UniversalEnergyStorage, Direction>,
Registerable {
    public static final EnergyBlockHolder INSTANCE = new EnergyBlockHolder();
    private final Set<Supplier<Block>> registeredBlocks = new HashSet<Supplier<Block>>();
    private final Set<Supplier<BlockEntityType<?>>> registeredBlockEntities = new HashSet();

    private EnergyBlockHolder() {
        this.registerSelf();
    }

    @Override
    @Nullable
    public UniversalEnergyStorage getCapability(Level level, BlockPos pos, Direction direction) {
        return this.getCapability(level, pos, (BlockState)null, (BlockEntity)null, direction);
    }

    @Override
    @Nullable
    public UniversalEnergyStorage getCapability(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, state, blockEntity, (Object)direction);
        return energyStorage == null ? null : new UniversalIEnergyStorage(energyStorage);
    }

    @Override
    public void registerForBlock(Supplier<Block> block) {
        this.registeredBlocks.add(block);
    }

    @Override
    public void registerForBlockEntity(Supplier<BlockEntityType<?>> blockEntityType) {
        this.registeredBlockEntities.add(blockEntityType);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Capabilities.EnergyStorage.BLOCK.name();
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredBlocks.forEach(block -> event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, blockEntity, direction) -> {
            if (blockEntity instanceof EnergyProvider.BLOCK) {
                EnergyProvider.BLOCK energyBlock = (EnergyProvider.BLOCK)blockEntity;
                UniversalEnergyStorage energy = energyBlock.getEnergy((Direction)direction);
                return energy == null ? null : new NeoForgeEnergyStorage(energy);
            }
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof EnergyProvider.BLOCK) {
                EnergyProvider.BLOCK energyBlock = (EnergyProvider.BLOCK)patt0$temp;
                UniversalEnergyStorage energy = energyBlock.getEnergy((Direction)direction);
                return energy == null ? null : new NeoForgeEnergyStorage(energy);
            }
            return null;
        }, new Block[]{(Block)block.get()}));
        this.registeredBlockEntities.forEach(type -> event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)type.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof EnergyProvider.BLOCK) {
                EnergyProvider.BLOCK energyBlock = (EnergyProvider.BLOCK)blockEntity;
                UniversalEnergyStorage energy = energyBlock.getEnergy((Direction)direction);
                return energy == null ? null : new NeoForgeEnergyStorage(energy);
            }
            return null;
        }));
    }
}

