/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.holders;

import com.fej1fun.potentials.capabilities.types.NoProviderEntityCapabilityHolder;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import com.fej1fun.potentials.neoforge.energy.NeoForgeEnergyStorage;
import com.fej1fun.potentials.neoforge.energy.UniversalIEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyEntityHolder
implements NoProviderEntityCapabilityHolder<UniversalEnergyStorage, Direction>,
Registerable {
    public static final EnergyEntityHolder INSTANCE = new EnergyEntityHolder();
    private final Set<Supplier<EntityType<? extends Entity>>> registeredEntities = new HashSet<Supplier<EntityType<? extends Entity>>>();

    private EnergyEntityHolder() {
        this.registerSelf();
    }

    @Override
    @Nullable
    public UniversalEnergyStorage getCapability(Entity entity, Direction direction) {
        if (entity == null) {
            return null;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)entity.getCapability(Capabilities.EnergyStorage.ENTITY, (Object)direction);
        return energyStorage == null ? null : new UniversalIEnergyStorage(energyStorage);
    }

    @Override
    public void registerForEntity(Supplier<EntityType<? extends Entity>> entity) {
        this.registeredEntities.add(entity);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Capabilities.EnergyStorage.ENTITY.name();
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredEntities.forEach(entityType -> event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)entityType.get(), (entity, ctx) -> {
            if (entity instanceof EnergyProvider.ENTITY) {
                EnergyProvider.ENTITY provider = (EnergyProvider.ENTITY)entity;
                UniversalEnergyStorage energy = provider.getEnergy((Direction)ctx);
                return energy == null ? null : new NeoForgeEnergyStorage(energy);
            }
            return null;
        }));
    }
}

