/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.holders;

import com.fej1fun.potentials.capabilities.types.NoProviderItemCapabilityHolder;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import com.fej1fun.potentials.neoforge.energy.NeoForgeEnergyStorage;
import com.fej1fun.potentials.neoforge.energy.UniversalIEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyItemHolder
implements NoProviderItemCapabilityHolder<UniversalEnergyStorage, Void>,
Registerable {
    public static final EnergyItemHolder INSTANCE = new EnergyItemHolder();
    private final Set<Supplier<Item>> registeredItems = new HashSet<Supplier<Item>>();

    private EnergyItemHolder() {
        this.registerSelf();
    }

    @Override
    @Nullable
    public UniversalEnergyStorage getCapability(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return energyStorage == null ? null : new UniversalIEnergyStorage(energyStorage);
    }

    @Override
    public void registerForItem(Supplier<Item> item) {
        this.registeredItems.add(item);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Capabilities.EnergyStorage.ITEM.name();
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredItems.forEach(item -> event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof EnergyProvider.ITEM) {
                EnergyProvider.ITEM energyItem = (EnergyProvider.ITEM)patt0$temp;
                UniversalEnergyStorage energy = energyItem.getEnergy((ItemStack)stack);
                return energy == null ? null : new NeoForgeEnergyStorage(energy);
            }
            return null;
        }, new ItemLike[]{(ItemLike)item.get()}));
    }
}

