/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.holders;

import com.fej1fun.potentials.capabilities.types.NoProviderFluidItemCapabilityHolder;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import com.fej1fun.potentials.neoforge.fluid.NeoForgeFluidHandlerItem;
import com.fej1fun.potentials.neoforge.fluid.UniversalFluidItemHandler;
import com.fej1fun.potentials.providers.FluidProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidItemHolder
implements NoProviderFluidItemCapabilityHolder<UniversalFluidItemStorage, Void>,
Registerable {
    public static final FluidItemHolder INSTANCE = new FluidItemHolder();
    private final Set<Supplier<Item>> registeredItems = new HashSet<Supplier<Item>>();

    private FluidItemHolder() {
        this.registerSelf();
    }

    @Override
    public UniversalFluidItemStorage getCapability(ItemStack stack) {
        IFluidHandlerItem fluidTank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return fluidTank == null ? null : new UniversalFluidItemHandler(fluidTank);
    }

    @Override
    public void registerForItem(Supplier<Item> item) {
        this.registeredItems.add(item);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Capabilities.FluidHandler.ITEM.name();
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredItems.forEach(item -> event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof FluidProvider.ITEM) {
                FluidProvider.ITEM fluidItem = (FluidProvider.ITEM)patt0$temp;
                UniversalFluidItemStorage fluid = fluidItem.getFluidTank((ItemStack)stack);
                return fluid == null ? null : new NeoForgeFluidHandlerItem(fluid);
            }
            return null;
        }, new ItemLike[]{(ItemLike)item.get()}));
    }
}

