/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.types;

import com.fej1fun.potentials.capabilities.types.BlockCapabilityHolder;
import com.fej1fun.potentials.capabilities.types.providers.BlockCapabilityProvider;
import com.fej1fun.potentials.capabilities.types.providers.CapabilityProvider;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class NeoBlockHolder<X, Y>
implements BlockCapabilityHolder<X, Y>,
Registerable {
    private final BlockCapability<X, Y> blockCapability;
    private final HashMap<Supplier<Block>, BlockCapabilityProvider<X, Y>> registeredBlocks = new HashMap();
    private final HashMap<Supplier<BlockEntityType<?>>, CapabilityProvider<BlockEntity, X, Y>> registeredBlockEntities = new HashMap();

    public NeoBlockHolder(BlockCapability<X, Y> blockCapability) {
        this.blockCapability = blockCapability;
        this.registerSelf();
    }

    @Override
    public X getCapability(Level level, BlockPos pos, Y context) {
        return (X)level.getCapability(this.blockCapability, pos, context);
    }

    @Override
    public X getCapability(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Y context) {
        return (X)level.getCapability(this.blockCapability, pos, state, blockEntity, context);
    }

    @Override
    public void registerForBlock(BlockCapabilityProvider<X, Y> provider, Supplier<Block> block) {
        this.registeredBlocks.put(block, provider);
    }

    @Override
    public void registerForBlockEntity(CapabilityProvider<BlockEntity, X, Y> provider, Supplier<BlockEntityType<?>> blockEntityType) {
        this.registeredBlockEntities.put(blockEntityType, provider);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return this.blockCapability.name();
    }

    public BlockCapability<X, Y> getBlockCapability() {
        return this.blockCapability;
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredBlocks.forEach((block, provider) -> event.registerBlock(this.getBlockCapability(), provider::getCapability, new Block[]{(Block)block.get()}));
        this.registeredBlockEntities.forEach((type, provider) -> event.registerBlockEntity(this.getBlockCapability(), (BlockEntityType)type.get(), provider::getCapability));
    }
}

