/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.datagen.recipes.neoforge;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.datagen.recipes.gen.CopycatsRecipeProvider;
import com.copycatsplus.copycats.datagen.recipes.gen.GeneratedRecipeBuilder;
import com.copycatsplus.copycats.datagen.recipes.neoforge.FeatureEnabledCondition;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class GeneratedRecipeBuilderNeoForge
implements GeneratedRecipeBuilder {
    private final List<ICondition> recipeConditions = new ArrayList<ICondition>();
    private String path = "";
    private String suffix;
    private Supplier<? extends ItemLike> result;
    private ResourceLocation compatDatagenOutput;
    private Supplier<ItemPredicate> unlockedBy;
    private int amount;

    private GeneratedRecipeBuilderNeoForge(String path) {
        this.path = path;
        this.suffix = "";
        this.amount = 1;
    }

    public GeneratedRecipeBuilderNeoForge(String path, Supplier<? extends ItemLike> result) {
        this(path);
        this.result = result;
    }

    public GeneratedRecipeBuilderNeoForge(String path, ResourceLocation result) {
        this(path);
        this.compatDatagenOutput = result;
    }

    @Override
    public GeneratedRecipeBuilder returns(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
        this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
        return this;
    }

    @Override
    public GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
        this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
        return this;
    }

    @Override
    public GeneratedRecipeBuilder withSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
        return this.handleConditions(consumer -> {
            ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
            if (this.unlockedBy != null) {
                b.unlockedBy("has_item", RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
            }
            b.save(consumer, this.createLocation("crafting"));
        });
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
        return this.handleConditions(consumer -> {
            ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
            if (this.unlockedBy != null) {
                b.unlockedBy("has_item", RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
            }
            b.save(consumer, this.createLocation("crafting"));
        });
    }

    private ResourceLocation clean(ResourceLocation loc) {
        String path = loc.getPath();
        while (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)path);
    }

    private ResourceLocation createSimpleLocation(String recipeType) {
        ResourceLocation loc = this.clean(Copycats.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix));
        return loc;
    }

    protected ResourceLocation createLocation(String recipeType) {
        ResourceLocation loc = this.clean(Copycats.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().getPath() + this.suffix));
        return loc;
    }

    private ResourceLocation getRegistryName() {
        return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)this.result.get().asItem()) : this.compatDatagenOutput;
    }

    @Override
    public GeneratedRecipeBuilder requiresResultFeature() {
        return this.requiresFeature(RegisteredObjectsHelper.getKeyOrThrow((Item)this.result.get().asItem()));
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(ResourceLocation location) {
        return this.requiresFeature(location, false);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block) {
        return this.requiresFeature(block, false);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block, boolean invert) {
        return this.requiresFeature(block.getId(), invert);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(ResourceLocation location, boolean invert) {
        this.recipeConditions.add(new FeatureEnabledCondition(location, invert));
        return this;
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe handleConditions(Consumer<RecipeOutput> recipe) {
        return CopycatsRecipeProvider.register(output -> {
            if (!this.recipeConditions.isEmpty()) {
                recipe.accept(output.withConditions(this.recipeConditions.toArray(new ICondition[0])));
            } else {
                recipe.accept(output);
            }
        });
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
        return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
        return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.of((TagKey)((TagKey)tag.get())));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
        return new GeneratedCookingRecipeBuilderNeoForge(ingredient);
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecutting(Supplier<? extends ItemLike> item) {
        return this.unlockedBy(item).viaStonecuttingIngredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecuttingTag(Supplier<TagKey<Item>> tag) {
        return this.unlockedByTag(tag).viaStonecuttingIngredient(() -> Ingredient.of((TagKey)((TagKey)tag.get())));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecuttingIngredient(Supplier<Ingredient> ingredient) {
        return new GeneratedStoneCuttingRecipeBuilderNeoForge(ingredient);
    }

    public class GeneratedCookingRecipeBuilderNeoForge
    implements GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder {
        private final Supplier<Ingredient> ingredient;
        private float exp;
        private int cookingTime;

        GeneratedCookingRecipeBuilderNeoForge(Supplier<Ingredient> ingredient) {
            this.ingredient = ingredient;
            this.cookingTime = 200;
            this.exp = 0.0f;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder forDuration(int duration) {
            this.cookingTime = duration;
            return this;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder rewardXP(float xp) {
            this.exp = xp;
            return this;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inFurnace() {
            return this.inFurnace(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
            return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inSmoker() {
            return this.inSmoker(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
            this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
            return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inBlastFurnace() {
            return this.inBlastFurnace(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
            this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
        }

        private <T extends AbstractCookingRecipe> GeneratedRecipeBuilder.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
            return CopycatsRecipeProvider.register(consumer -> {
                boolean isOtherMod = GeneratedRecipeBuilderNeoForge.this.compatDatagenOutput != null;
                SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.DIRT : GeneratedRecipeBuilderNeoForge.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                if (GeneratedRecipeBuilderNeoForge.this.unlockedBy != null) {
                    b.unlockedBy("has_item", RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilderNeoForge.this.unlockedBy.get()}));
                }
                b.save(consumer, GeneratedRecipeBuilderNeoForge.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
            });
        }
    }

    public class GeneratedStoneCuttingRecipeBuilderNeoForge
    implements GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder {
        private final Supplier<Ingredient> ingredient;

        GeneratedStoneCuttingRecipeBuilderNeoForge(Supplier<Ingredient> ingredient) {
            this.ingredient = ingredient;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe create() {
            return this.create(b -> b);
        }

        private GeneratedRecipeBuilder.GeneratedRecipe create(UnaryOperator<SingleItemRecipeBuilder> builder) {
            return GeneratedRecipeBuilderNeoForge.this.handleConditions(consumer -> {
                SingleItemRecipeBuilder b = (SingleItemRecipeBuilder)builder.apply(SingleItemRecipeBuilder.stonecutting((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)GeneratedRecipeBuilderNeoForge.this.result.get(), (int)GeneratedRecipeBuilderNeoForge.this.amount));
                if (GeneratedRecipeBuilderNeoForge.this.unlockedBy != null) {
                    b.unlockedBy("has_item", RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilderNeoForge.this.unlockedBy.get()}));
                }
                b.save(consumer, GeneratedRecipeBuilderNeoForge.this.createLocation("stonecutting"));
            });
        }
    }
}

