/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.client.input;

import com.github.flandre923.berrypouch.client.input.CycleBaitAction;
import com.github.flandre923.berrypouch.client.input.KeyAction;
import com.github.flandre923.berrypouch.client.input.OpenPouchAction;
import com.github.flandre923.berrypouch.client.input.ToggleAutoBerryAction;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public class KeyBindingManager {
    public static final String KEY_CATEGORY = "key.categories.berrypouch";
    public static final String KEY_OPEN_POUCH = "key.berrypouch.open_pouch";
    public static final String KEY_CYCLE_BAIT_LEFT = "key.berrypouch.cycle_bait_left";
    public static final String KEY_CYCLE_BAIT_RIGHT = "key.berrypouch.cycle_bait_right";
    public static final String KEY_TOGGLE_AUTO_BERRY = "key.berrypouch.toggle_auto_berry";
    private static final Map<KeyMapping, KeyAction> KEY_ACTIONS = new HashMap<KeyMapping, KeyAction>();

    public static Map<KeyMapping, KeyAction> getKeyActions() {
        return KEY_ACTIONS;
    }

    public static void register() {
        KeyBindingManager.registerKeyBinding(new KeyMapping(KEY_OPEN_POUCH, InputConstants.Type.KEYSYM, 80, KEY_CATEGORY), new OpenPouchAction());
        KeyBindingManager.registerKeyBinding(new KeyMapping(KEY_CYCLE_BAIT_LEFT, InputConstants.Type.KEYSYM, 91, KEY_CATEGORY), new CycleBaitAction(true));
        KeyBindingManager.registerKeyBinding(new KeyMapping(KEY_CYCLE_BAIT_RIGHT, InputConstants.Type.KEYSYM, 93, KEY_CATEGORY), new CycleBaitAction(false));
        KeyBindingManager.registerKeyBinding(new KeyMapping(KEY_TOGGLE_AUTO_BERRY, InputConstants.Type.KEYSYM, 92, KEY_CATEGORY), new ToggleAutoBerryAction());
    }

    private static void registerKeyBinding(KeyMapping mapping, KeyAction action) {
        KEY_ACTIONS.put(mapping, action);
        KeyMappingRegistry.register((KeyMapping)mapping);
    }

    public static void checkKeyInputs() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        KEY_ACTIONS.forEach((mapping, action) -> {
            while (mapping.consumeClick()) {
                if (!action.shouldTrigger((Player)mc.player)) continue;
                action.onKeyPressed(mc);
            }
        });
    }
}

