/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.helper;

import com.github.flandre923.berrypouch.ModRegistries;
import com.github.flandre923.berrypouch.mobinf.IAutoFillablePlayer;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PouchDataHelper {
    public static Optional<ResourceLocation> getLastUsedBait(ItemStack pouchStack) {
        if (pouchStack == null || pouchStack.isEmpty()) {
            return Optional.empty();
        }
        return (Optional)pouchStack.getOrDefault((DataComponentType)ModRegistries.ModDataComponentes.LAST_USED_BAIT.get(), Optional.empty());
    }

    public static void setLastUsedBait(ItemStack pouchStack, Item baitItem) {
        if (pouchStack == null || pouchStack.isEmpty() || baitItem == null) {
            return;
        }
        ResourceLocation itemRL = BuiltInRegistries.ITEM.getKey((Object)baitItem);
        if (!itemRL.equals((Object)BuiltInRegistries.ITEM.getDefaultKey())) {
            pouchStack.set((DataComponentType)ModRegistries.ModDataComponentes.LAST_USED_BAIT.get(), Optional.of(itemRL));
        } else {
            PouchDataHelper.clearLastUsedBait(pouchStack);
        }
    }

    public static void clearLastUsedBait(ItemStack pouchStack) {
        if (pouchStack == null || pouchStack.isEmpty()) {
            return;
        }
        pouchStack.set((DataComponentType)ModRegistries.ModDataComponentes.LAST_USED_BAIT.get(), Optional.empty());
    }

    public static boolean isAutoBerryEnabled(ServerPlayer player) {
        if (player instanceof IAutoFillablePlayer) {
            IAutoFillablePlayer mixin = (IAutoFillablePlayer)player;
            return mixin.berryPouch$getAutoFillBerryuPouch();
        }
        return false;
    }

    public static void setAutoBerryEnabled(ServerPlayer player, boolean newState) {
        if (player instanceof IAutoFillablePlayer) {
            IAutoFillablePlayer mixin = (IAutoFillablePlayer)player;
            mixin.berryPouch$setAutoFillBerryPouch(newState);
        }
    }
}

