/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4fStack;

public class RenderHelper {
    public static void renderGuiItemAlpha(ItemStack stack, int x, int y, int alpha, ItemRenderer renderer) {
        RenderHelper.renderGuiItemAlpha(stack, x, y, alpha, renderer.getModel(stack, null, null, 0), renderer);
    }

    public static void renderGuiItemAlpha(ItemStack stack, int x, int y, int alpha, BakedModel model, ItemRenderer renderer) {
        boolean flatLight;
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate((float)x, (float)y, 100.0f);
        modelViewStack.translate(8.0f, 8.0f, 0.0f);
        modelViewStack.scale(1.0f, -1.0f, 1.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        boolean bl = flatLight = !model.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        renderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), RenderHelper.wrapBuffer((MultiBufferSource)buffer, alpha, alpha < 255), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.getBuffer(forceTranslucent ? RenderType.translucent() : renderType), alpha);
    }

    public record GhostVertexConsumer(VertexConsumer wrapped, int alpha) implements VertexConsumer
    {
        public VertexConsumer addVertex(float f, float g, float h) {
            return this.wrapped.addVertex(f, g, h);
        }

        public VertexConsumer setColor(int i, int j, int k, int alpha) {
            return this.wrapped.setColor(i, j, k, alpha * this.alpha / 255);
        }

        public VertexConsumer setUv(float f, float g) {
            return this.wrapped.setUv(f, g);
        }

        public VertexConsumer setUv1(int i, int j) {
            return this.wrapped.setUv1(i, j);
        }

        public VertexConsumer setUv2(int i, int j) {
            return this.wrapped.setUv2(i, j);
        }

        public VertexConsumer setNormal(float f, float g, float h) {
            return this.wrapped.setNormal(f, g, h);
        }
    }
}

