/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.item;

import com.github.flandre923.berrypouch.item.pouch.BerryPouchManager;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoryItem;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BerryPouch
extends AccessoryItem {
    private final BerryPouchType pouchType;

    public BerryPouch(BerryPouchType pouchType) {
        super(new Item.Properties().stacksTo(1));
        this.pouchType = pouchType;
    }

    public int getSize() {
        return this.pouchType.getSize();
    }

    public BerryPouchType getPouchType() {
        return this.pouchType;
    }

    private static boolean isBerry(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return BerryPouchType.LARGE.getStorageSlot().has(item);
    }

    public static boolean onPickupItem(ItemEntity itemEntity, Player player) {
        ItemStack itemStack = itemEntity.getItem();
        if (!BerryPouch.isBerry(itemStack)) {
            return false;
        }
        if (BerryPouch.onPickupItem(itemEntity.getItem(), player)) {
            if (itemEntity.getItem().isEmpty() || itemEntity.getItem().getCount() == 0) {
                itemEntity.discard();
            }
            return true;
        }
        return false;
    }

    public static boolean onPickupItem(ItemStack itemStack, Player player) {
        if (!BerryPouch.isBerry(itemStack)) {
            return false;
        }
        AccessoriesCapability accessoriesCap = AccessoriesCapability.get((LivingEntity)player);
        if (accessoriesCap != null) {
            List equippedPouches = accessoriesCap.getEquipped(stack -> stack.getItem() instanceof BerryPouch);
            for (SlotEntryReference entryRef : equippedPouches) {
                if (!BerryPouch.tryInsertItemStack(entryRef.stack(), itemStack, player.level(), player)) continue;
                return true;
            }
        }
        Inventory playerInventory = player.getInventory();
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack pouchStack = playerInventory.getItem(i);
            Item item = pouchStack.getItem();
            if (!(item instanceof BerryPouch)) continue;
            BerryPouch berryPouch = (BerryPouch)item;
            if (!BerryPouch.tryInsertItemStack(pouchStack, itemStack, player.level(), player)) continue;
            return true;
        }
        return false;
    }

    public static boolean tryInsertItemStack(ItemStack container, ItemStack itemToInsert, Level level, Player player) {
        int i;
        if (!(container.getItem() instanceof BerryPouch)) {
            return false;
        }
        SimpleContainer inventory = BerryPouchManager.getInventory(container, level);
        boolean success = false;
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            int space;
            ItemStack existingStack = inventory.getItem(i);
            if (existingStack.isEmpty() || !ItemStack.isSameItem((ItemStack)existingStack, (ItemStack)itemToInsert) || (space = existingStack.getMaxStackSize() - existingStack.getCount()) <= 0) continue;
            int toTransfer = Math.min(space, itemToInsert.getCount());
            existingStack.grow(toTransfer);
            itemToInsert.shrink(toTransfer);
            if (itemToInsert.isEmpty()) {
                inventory.setChanged();
                success = true;
                break;
            }
            inventory.setChanged();
            success = true;
        }
        if (!success && !itemToInsert.isEmpty()) {
            for (i = 0; i < inventory.getContainerSize(); ++i) {
                if (!inventory.getItem(i).isEmpty() || !inventory.canPlaceItem(i, itemToInsert)) continue;
                inventory.setItem(i, itemToInsert.copy());
                itemToInsert.setCount(0);
                success = true;
                break;
            }
        }
        if (success && !level.isClientSide) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return success;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Item item = stack.getItem();
            if (item instanceof BerryPouch) {
                BerryPouch pouchItem = (BerryPouch)item;
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BUNDLE_INSERT, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                BerryPouchManager.openPouchGUI(serverPlayer, stack, interactionHand == InteractionHand.MAIN_HAND ? 0 : 1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        return reference.slotName().equals("pouch");
    }

    public void onEquip(ItemStack stack, SlotReference ref) {
    }
}

