/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.item.pouch;

import com.github.flandre923.berrypouch.helper.ItemNBTHelper;
import com.github.flandre923.berrypouch.item.IBerryPouchStorage;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import net.minecraft.core.NonNullList;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BerryPouchInventory
extends SimpleContainer {
    private final ItemStack pouchStack;
    private final Level level;
    private IBerryPouchStorage pouchStorageSlot;
    private final BerryPouchType pouchType;

    public BerryPouchInventory(ItemStack pouchStack, Level level, BerryPouchType pouchType) {
        super(pouchType.getSize());
        this.pouchStack = pouchStack;
        this.level = level;
        this.pouchType = pouchType;
        this.pouchStorageSlot = pouchType.getStorageSlot();
        this.loadFromNBT();
    }

    private void loadFromNBT() {
        NonNullList<ItemStack> items = ItemNBTHelper.getList(this.pouchStack, false, this.level);
        for (int i = 0; i < Math.min(items.size(), this.getContainerSize()); ++i) {
            this.setItem(i, (ItemStack)items.get(i));
        }
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        if (this.pouchStorageSlot != null) {
            return this.pouchStorageSlot.matchesSlotItem(slot + 1, stack.getItem());
        }
        return true;
    }

    public boolean stillValid(Player player) {
        return !this.pouchStack.isEmpty();
    }

    public void setChanged() {
        super.setChanged();
        ItemNBTHelper.setList(this.pouchStack, (NonNullList<ItemStack>)this.getItems(), this.level);
    }
}

