/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.item.pouch;

import com.github.flandre923.berrypouch.item.BerryPouchGui24StorageSlot;
import com.github.flandre923.berrypouch.item.BerryPouchGui30StorageSlot;
import com.github.flandre923.berrypouch.item.BerryPouchGui69StorageSlot;
import com.github.flandre923.berrypouch.item.IBerryPouchStorage;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;

public enum BerryPouchType {
    SMALL(24, 175, 161, "small", "berry_pouch_small", new BerryPouchGui24StorageSlot(24), 8, 2, 8, 84),
    MEDIUM(30, 208, 202, "medium", "berry_pouch_medium", new BerryPouchGui30StorageSlot(30), 21, 2, 21, 84),
    LARGE(69, 256, 255, "large", "berry_pouch_large", new BerryPouchGui69StorageSlot(69), 25, 2, 44, 147);

    private final int size;
    private final int guiWidth;
    private final int guiHeight;
    private final String name;
    private final String registryName;
    private final IBerryPouchStorage storageSlot;
    private final int titleX;
    private final int titleY;
    private final int inventoryX;
    private final int inventoryY;

    private BerryPouchType(int size, int guiWidth, int guiHeight, String name, String registryName, IBerryPouchStorage storageSlot, int titleX, int titleY, int inventoryX, int inventoryY) {
        this.size = size;
        this.guiHeight = guiHeight;
        this.guiWidth = guiWidth;
        this.name = name;
        this.registryName = registryName;
        this.storageSlot = storageSlot;
        this.titleX = titleX;
        this.titleY = titleY;
        this.inventoryX = inventoryX;
        this.inventoryY = inventoryY;
    }

    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"berrypouch", (String)("textures/gui/berry_pouch_" + this.name + ".png"));
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public ResourceLocation getRegistryLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"berrypouch", (String)this.registryName);
    }

    public static BerryPouchType fromSize(int size) {
        return Arrays.stream(BerryPouchType.values()).filter(type -> type.size == size).findFirst().orElse(SMALL);
    }

    public IBerryPouchStorage getStorageSlot() {
        return this.storageSlot;
    }

    public int getSize() {
        return this.size;
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public int getTitleX() {
        return this.titleX;
    }

    public int getTitleY() {
        return this.titleY;
    }

    public int getInventoryX() {
        return this.inventoryX;
    }

    public int getInventoryY() {
        return this.inventoryY;
    }
}

