/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.menu.container;

import com.github.flandre923.berrypouch.ModRegistries;
import com.github.flandre923.berrypouch.helper.PouchItemHelper;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import com.github.flandre923.berrypouch.menu.container.AbstractBerryPouchContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LargeBerryPouchContainer
extends AbstractBerryPouchContainer {
    private final ItemStack pouchStack;

    public LargeBerryPouchContainer(int windowId, Inventory playerInv, ItemStack pouchStack) {
        super((MenuType)ModRegistries.ModMenuTypes.BERRY_POUCH_CONTAINER_69.get(), windowId, playerInv, pouchStack, BerryPouchType.LARGE);
        this.pouchStack = pouchStack;
    }

    public static LargeBerryPouchContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        int isHand = buf.readInt();
        ItemStack item = isHand == 0 ? inv.player.getItemInHand(InteractionHand.MAIN_HAND) : (isHand == 1 ? inv.player.getItemInHand(InteractionHand.OFF_HAND) : PouchItemHelper.findBerryPouch(inv.player));
        return new LargeBerryPouchContainer(windowId, inv, item);
    }

    @Override
    protected void addPouchSlots() {
        int slotIndex;
        int col;
        int row;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 8; ++col) {
                slotIndex = col + row * 8;
                this.addBerrySlot(slotIndex, 35 + col * 18, 16 + row * 18);
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 2; ++col) {
                slotIndex = 24 + row * 2 + col;
                this.addBerrySlot(slotIndex, 187 + col * 18, 16 + row * 18);
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 13; ++col) {
                slotIndex = 30 + row * 13 + col;
                this.addBerrySlot(slotIndex, 12 + col * 18, 79 + row * 18);
            }
        }
    }

    private void addBerrySlot(final int slotIndex, int x, int y) {
        this.addSlot(new Slot(this, this.pouchInventory, slotIndex, x, y){

            public boolean mayPlace(ItemStack stack) {
                return BerryPouchType.LARGE.getStorageSlot().matchesSlotItem(slotIndex + 1, stack.getItem());
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot clickedSlot = (Slot)this.slots.get(slotIndex);
        if (clickedSlot != null && clickedSlot.hasItem()) {
            ItemStack originalStack = clickedSlot.getItem().copy();
            returnStack = originalStack.copy();
            if (slotIndex < BerryPouchType.LARGE.getSize()) {
                if (!this.moveItemStackTo(originalStack, BerryPouchType.LARGE.getSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (BerryPouchType.LARGE.getStorageSlot().has(originalStack.getItem())) {
                if (!this.moveItemStackTo(originalStack, 0, BerryPouchType.LARGE.getSize(), false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                clickedSlot.set(ItemStack.EMPTY);
            } else {
                clickedSlot.set(originalStack);
                clickedSlot.setChanged();
            }
            if (originalStack.getCount() == returnStack.getCount()) {
                return ItemStack.EMPTY;
            }
            clickedSlot.onTake(player, originalStack);
        }
        return returnStack;
    }
}

