/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.mixins;

import com.github.flandre923.berrypouch.item.BerryPouch;
import java.util.UUID;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public class ItemEntityMixin {
    @Shadow
    private int pickupDelay;
    @Shadow
    private UUID thrower;

    @Inject(at={@At(value="HEAD")}, method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, cancellable=true)
    private void onPickup(Player player, CallbackInfo ci) {
        ItemEntity self = (ItemEntity)this;
        if (!player.level().isClientSide && this.pickupDelay == 0 && (this.thrower == null || this.thrower.equals(player.getUUID())) && BerryPouch.onPickupItem(self, player)) {
            ci.cancel();
        }
    }
}

