/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.network;

import com.cobblemon.mod.common.item.interactive.PokerodItem;
import com.github.flandre923.berrypouch.ModCommon;
import com.github.flandre923.berrypouch.event.FishingRodEventHandler;
import com.github.flandre923.berrypouch.helper.MarkedSlotsHelper;
import com.github.flandre923.berrypouch.helper.PouchDataHelper;
import com.github.flandre923.berrypouch.item.BerryPouch;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchManager;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import com.github.flandre923.berrypouch.menu.container.AbstractBerryPouchContainer;
import com.github.flandre923.berrypouch.network.CycleBaitPacket;
import com.github.flandre923.berrypouch.network.OpenPouchPayload;
import com.github.flandre923.berrypouch.network.ToggleAutoBerryPayload;
import com.github.flandre923.berrypouch.network.ToggleMarkSlotPayload;
import dev.architectury.networking.NetworkManager;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ModNetworking {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, OpenPouchPayload.TYPE, OpenPouchPayload.CODEC, ModNetworking::handleOpenPouch);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, CycleBaitPacket.TYPE, CycleBaitPacket.CODEC, (packet, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            context.queue(() -> ModNetworking.handleCycleBaitRequest(player, packet.isMainHand(), packet.isLeftCycle()));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ToggleMarkSlotPayload.TYPE, ToggleMarkSlotPayload.CODEC, ModNetworking::handleToggleMarkSlot);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ToggleAutoBerryPayload.TYPE, ToggleAutoBerryPayload.CODEC, (packet, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            context.queue(() -> ModNetworking.handleToggleAutoBerry(player));
        });
    }

    private static void handleOpenPouch(OpenPouchPayload payload, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        Level level = player.level();
        context.queue(() -> {
            AccessoriesCapability accessoriesCap = AccessoriesCapability.get((LivingEntity)player);
            if (accessoriesCap == null) {
                return;
            }
            accessoriesCap.getEquipped(stack -> stack.getItem() instanceof BerryPouch).stream().findFirst().ifPresent(entry -> {
                Item patt0$temp;
                ItemStack pouchStack = entry.stack();
                if (!pouchStack.isEmpty() && (patt0$temp = pouchStack.getItem()) instanceof BerryPouch) {
                    BerryPouch pouchItem = (BerryPouch)patt0$temp;
                    if (!player.level().isClientSide) {
                        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BUNDLE_INSERT, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                        BerryPouchManager.openPouchGUI(player, pouchStack, 2);
                    }
                }
            });
        });
    }

    private static void handleCycleBaitRequest(ServerPlayer player, boolean isMainHand, boolean isLeftCycle) {
        int nextIndex;
        int currentIndex;
        ArrayList<Item> finalAvailableBerryTypes;
        Level level = player.level();
        InteractionHand hand = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack heldStack = player.getItemInHand(hand);
        if (!FishingRodEventHandler.isCobblemonFishingRod(heldStack)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.not_holding_rod"), true);
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability == null) {
            return;
        }
        Optional<SlotEntryReference> pouchRefOpt = Optional.ofNullable(capability.getFirstEquipped(stack -> stack.getItem() instanceof BerryPouch));
        if (pouchRefOpt.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.need_pouch"), true);
            return;
        }
        ItemStack pouchStack = pouchRefOpt.get().stack();
        Item item = pouchStack.getItem();
        if (!(item instanceof BerryPouch)) {
            return;
        }
        BerryPouch pouchItem = (BerryPouch)item;
        List<Integer> markedSlots = MarkedSlotsHelper.getMarkedSlots(pouchStack);
        boolean preferMarked = !markedSlots.isEmpty();
        SimpleContainer pouchItems = BerryPouchManager.getInventory(pouchStack, level);
        ArrayList<Item> availableMarkedItemTypes = new ArrayList<Item>();
        if (preferMarked) {
            for (int markedIndex : markedSlots) {
                ItemStack stackInSlot;
                if (markedIndex < 0 || markedIndex >= pouchItems.getContainerSize() || (stackInSlot = pouchItems.getItem(markedIndex)).isEmpty() || !FishingRodEventHandler.isCobblemonBerry(stackInSlot) || availableMarkedItemTypes.contains(stackInSlot.getItem())) continue;
                availableMarkedItemTypes.add(stackInSlot.getItem());
            }
        }
        ArrayList<Item> allAvailableItemTypes = new ArrayList<Item>();
        for (ItemStack stackInSlot : pouchItems.getItems()) {
            if (stackInSlot.isEmpty() || !FishingRodEventHandler.isCobblemonBerry(stackInSlot) || allAvailableItemTypes.contains(stackInSlot.getItem())) continue;
            allAvailableItemTypes.add(stackInSlot.getItem());
        }
        Item currentBaitItem = null;
        ItemStack currentBaitStackOnRod = PokerodItem.Companion.getBaitStackOnRod(heldStack);
        boolean returnedToPouch = false;
        if (!currentBaitStackOnRod.isEmpty()) {
            currentBaitItem = currentBaitStackOnRod.getItem();
            ItemStack baitToReturn = currentBaitStackOnRod.copy();
            for (int i = 0; i < pouchItems.getContainerSize(); ++i) {
                int space = pouchItems.getItem(i).getMaxStackSize() - pouchItems.getItem(i).getCount();
                if (!pouchItems.canPlaceItem(i, baitToReturn) || space <= 0) continue;
                pouchItems.getItem(i).grow(1);
                returnedToPouch = true;
            }
            if (returnedToPouch) {
                PokerodItem.Companion.setBait(heldStack, ItemStack.EMPTY);
            } else {
                ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), baitToReturn);
                itemEntity.setPickUpDelay(10);
                level.addFreshEntity((Entity)itemEntity);
                player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.bait_dropped", (Object[])new Object[]{Component.translatable((String)currentBaitItem.getDescriptionId())}), true);
                PokerodItem.Companion.setBait(heldStack, ItemStack.EMPTY);
            }
        }
        if (preferMarked && availableMarkedItemTypes.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.marked_bait_exhausted_switching_none"), true);
            PokerodItem.Companion.setBait(heldStack, ItemStack.EMPTY);
            if (returnedToPouch) {
                pouchItems.setChanged();
            }
            player.inventoryMenu.broadcastChanges();
            if (player.containerMenu != player.inventoryMenu) {
                player.containerMenu.broadcastChanges();
            }
            return;
        }
        boolean cyclingMarked = false;
        if (preferMarked) {
            finalAvailableBerryTypes = availableMarkedItemTypes;
            cyclingMarked = true;
        } else if (!allAvailableItemTypes.isEmpty()) {
            finalAvailableBerryTypes = allAvailableItemTypes;
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.no_bait_in_pouch"), true);
            if (returnedToPouch) {
                pouchItems.setChanged();
            }
            return;
        }
        int n = currentIndex = currentBaitItem != null ? finalAvailableBerryTypes.indexOf(currentBaitItem) : -1;
        if (currentIndex == -1 && !finalAvailableBerryTypes.isEmpty()) {
            currentIndex = isLeftCycle ? 0 : finalAvailableBerryTypes.size() - 1;
        } else if (finalAvailableBerryTypes.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.no_bait_in_pouch"), true);
            if (returnedToPouch) {
                pouchItems.setChanged();
            }
            return;
        }
        int n2 = nextIndex = isLeftCycle ? (currentIndex - 1 + finalAvailableBerryTypes.size()) % finalAvailableBerryTypes.size() : (currentIndex + 1) % finalAvailableBerryTypes.size();
        if (nextIndex < 0 || nextIndex >= finalAvailableBerryTypes.size()) {
            ModCommon.LOG.error("Error calculating next bait index. Current: {}, Next: {}, Size: {}", new Object[]{currentIndex, nextIndex, finalAvailableBerryTypes.size()});
            if (returnedToPouch) {
                pouchItems.setChanged();
            }
            return;
        }
        Item nextBaitItem = (Item)finalAvailableBerryTypes.get(nextIndex);
        boolean deducted = false;
        if (cyclingMarked) {
            for (int markedIndex : markedSlots) {
                ItemStack stackInSlot;
                if (markedIndex < 0 || markedIndex >= pouchItems.getContainerSize() || (stackInSlot = pouchItems.getItem(markedIndex)).isEmpty() || !stackInSlot.is(nextBaitItem)) continue;
                stackInSlot.shrink(1);
                deducted = true;
                break;
            }
        } else {
            for (int i = 0; i < pouchItems.getContainerSize(); ++i) {
                ItemStack stackInSlot = pouchItems.getItem(i);
                if (stackInSlot.isEmpty() || !stackInSlot.is(nextBaitItem)) continue;
                stackInSlot.shrink(1);
                deducted = true;
                break;
            }
        }
        if (!deducted) {
            ModCommon.LOG.warn("Failed to deduct bait {} even though it was expected to be available.", (Object)nextBaitItem);
            player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.berry_missing_after_selection"), true);
            if (returnedToPouch) {
                pouchItems.setChanged();
            }
            PokerodItem.Companion.setBait(heldStack, ItemStack.EMPTY);
            player.inventoryMenu.broadcastChanges();
            if (player.containerMenu != player.inventoryMenu) {
                player.containerMenu.broadcastChanges();
            }
            return;
        }
        PokerodItem.Companion.setBait(heldStack, new ItemStack((ItemLike)nextBaitItem, 1));
        PouchDataHelper.setLastUsedBait(pouchStack, nextBaitItem);
        pouchItems.setChanged();
        player.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.switched_bait", (Object[])new Object[]{Component.translatable((String)nextBaitItem.getDescriptionId())}), true);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.UI_BUTTON_CLICK, SoundSource.PLAYERS, 0.5f, 1.5f);
        player.inventoryMenu.broadcastChanges();
        if (player.containerMenu != player.inventoryMenu) {
            player.containerMenu.broadcastChanges();
        }
    }

    private static void handleToggleMarkSlot(ToggleMarkSlotPayload packet, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        int slotIndex = packet.slotIndex();
        context.queue(() -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractBerryPouchContainer) {
                AbstractBerryPouchContainer pouchContainer = (AbstractBerryPouchContainer)patt0$temp;
                ItemStack pouchStack = pouchContainer.getPouchStack();
                if (!pouchStack.isEmpty() && pouchStack.getItem() instanceof BerryPouch) {
                    BerryPouchType pouchType = ((BerryPouch)pouchStack.getItem()).getPouchType();
                    if (slotIndex >= 0 && slotIndex < pouchType.getSize()) {
                        MarkedSlotsHelper.toggleMarkedSlot(pouchStack, slotIndex);
                        player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.5f, 1.2f);
                        pouchContainer.broadcastChanges();
                    } else {
                        ModCommon.LOG.warn("Player {} tried to toggle invalid slot index {} for pouch {}", new Object[]{player.getName().getString(), slotIndex, pouchStack.getHoverName().getString()});
                    }
                } else {
                    ModCommon.LOG.warn("Player {} sent ToggleMarkSlotPacket but the container's pouchStack is invalid", (Object)player.getName().getString());
                }
            } else {
                ModCommon.LOG.warn("Player {} sent ToggleMarkSlotPacket but is not in a BerryPouchContainer", (Object)player.getName().getString());
            }
        });
    }

    private static void handleToggleAutoBerry(ServerPlayer player) {
        boolean oldState = PouchDataHelper.isAutoBerryEnabled(player);
        boolean newState = !oldState;
        PouchDataHelper.setAutoBerryEnabled(player, newState);
        if (oldState) {
            InteractionHand[] hands;
            Level level = player.level();
            for (InteractionHand hand : hands = new InteractionHand[]{InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND}) {
                ItemStack heldStack = player.getItemInHand(hand);
                if (!FishingRodEventHandler.isCobblemonFishingRod(heldStack)) continue;
                ItemStack currentBait = PokerodItem.Companion.getBaitStackOnRod(heldStack);
                BerryPouch.onPickupItem(currentBait, (Player)player);
                if (currentBait.isEmpty()) continue;
                PokerodItem.Companion.setBait(heldStack, ItemStack.EMPTY);
                break;
            }
        }
        MutableComponent message = Component.translatable((String)("message.berrypouch.auto_berry_toggled." + newState));
        player.sendSystemMessage((Component)message, true);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.UI_BUTTON_CLICK, SoundSource.PLAYERS, 0.5f, 1.2f);
    }

    public static void sendOpenPouchPacketToServer() {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().getConnection() != null) {
            NetworkManager.sendToServer((CustomPacketPayload)new OpenPouchPayload());
        } else {
            ModCommon.LOG.warn("Attempted to send OpenPouchPayload when not in a valid client context!");
        }
    }

    public static void sendToggleMarkSlotPacketToServer(int slotIndex) {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().getConnection() != null) {
            NetworkManager.sendToServer((CustomPacketPayload)new ToggleMarkSlotPayload(slotIndex));
        } else {
            ModCommon.LOG.warn("Attempted to send ToggleMarkSlotPayload when not in a valid client context!");
        }
    }
}

