/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.recipe;

import com.github.flandre923.berrypouch.ModRegistries;
import com.github.flandre923.berrypouch.item.BerryPouch;
import com.github.flandre923.berrypouch.mixins.ShapedRecipeMixin;
import com.github.flandre923.berrypouch.recipe.IWrapperRecipe;
import com.github.flandre923.berrypouch.recipe.RecipeWrapperSerializer;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class BerryPouchUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public BerryPouchUpgradeRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), compose.category(), ((ShapedRecipeMixin)compose).getPatternAccessor(), ((ShapedRecipeMixin)compose).getResultAccess());
        this.compose = compose;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack upgradedBackpack = super.assemble(inv, registries);
        this.getBerryPouch(inv).map(ItemStack::getComponents).ifPresent(arg_0 -> ((ItemStack)upgradedBackpack).applyComponents(arg_0));
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBerryPouch(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (!(slotStack.getItem() instanceof BerryPouch)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRegistries.Recipes.BACKPACK_UPGRADE_RECIPE_SERIALIZER.get();
    }

    @Override
    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, BerryPouchUpgradeRecipe> {
        public Serializer() {
            super(BerryPouchUpgradeRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

