/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.energy;

import java.util.Objects;
import tv.soaryn.xycraft.core.container.energy.EnergyContainer;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.TransferAction;
import tv.soaryn.xycraft.core.utils.protocontainer.energy.IEnergyHandler;

public record EnergyContainerToHandlerAdapter(EnergyContainer container, HandlerIOBehavior behavior) implements IEnergyHandler.IEnergyHandlerModifiable
{
    @Override
    public int size() {
        return this.container.size();
    }

    @Override
    public boolean allowsInsertion() {
        for (int i = 0; i < this.container.size(); ++i) {
            if (!this.allowsInsertion(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsExtraction() {
        for (int i = 0; i < this.container.size(); ++i) {
            if (!this.allowsExtraction(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsInsertion(int index) {
        return this.behavior.canInsert(index);
    }

    @Override
    public boolean allowsExtraction(int index) {
        return this.behavior.canExtract(index);
    }

    @Override
    public int getAmount(int index) {
        return this.container.get(index);
    }

    @Override
    public int getCapacity(int index) {
        return this.container.getCapacity(index);
    }

    @Override
    public int insert(int amount, TransferAction action) {
        int handled = 0;
        for (int index = 0; index < this.size(); ++index) {
            Objects.checkIndex(index, this.size());
            if (handled == amount) break;
            handled += this.indexInsert(index, amount - handled, action);
        }
        return handled;
    }

    @Override
    public int insert(int index, int amount, TransferAction action) {
        Objects.checkIndex(index, this.size());
        return this.indexInsert(index, amount, action);
    }

    private int indexInsert(int index, int amount, TransferAction action) {
        int currentAmount;
        if (!this.behavior.canInsert(index)) {
            return 0;
        }
        int capacity = this.container.getCapacity(index);
        int handledAmount = Math.min(capacity - (currentAmount = this.container.get(index)), amount);
        if (handledAmount > 0 && action.isExecuting()) {
            this.set(index, currentAmount + handledAmount);
        }
        return handledAmount;
    }

    @Override
    public int extract(int index, int amount, TransferAction action) {
        Objects.checkIndex(index, this.size());
        if (amount <= 0) {
            return 0;
        }
        return this.indexedExtract(index, amount, action);
    }

    private int indexedExtract(int index, int amount, TransferAction action) {
        if (!this.behavior.canExtract(index)) {
            return 0;
        }
        int currentAmount = this.container.get(index);
        int handledAmount = Math.min(amount, currentAmount);
        if (action.isExecuting()) {
            this.set(index, currentAmount - handledAmount);
        }
        return handledAmount;
    }

    @Override
    public int extract(int amount, TransferAction action) {
        if (amount <= 0) {
            return 0;
        }
        int handled = 0;
        for (int index = 0; index < this.container.size(); ++index) {
            Objects.checkIndex(index, this.size());
            if (handled == amount) break;
            handled += this.indexedExtract(index, amount - handled, action);
        }
        return handled;
    }

    @Override
    public void set(int index, int amount) {
        Objects.checkIndex(index, this.size());
        this.container.set(index, amount);
    }
}

