/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item;

import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Contract;
import tv.soaryn.xycraft.core.container.item.ContainerToItemContainerAdapter;
import tv.soaryn.xycraft.core.container.item.ItemContainerSlice;
import tv.soaryn.xycraft.core.container.item.ItemContainerToContainerAdapter;
import tv.soaryn.xycraft.core.container.item.ItemContainerToItemHandlerAdapter;
import tv.soaryn.xycraft.core.container.item.ItemHandlerToItemContainerAdapter;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;

public interface ItemContainer
extends Iterable<ItemStack> {
    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static ItemContainer of(int slots) {
        return new SimpleItemContainer(slots);
    }

    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static ItemContainer copyOf(@Nonnull NonNullList<ItemStack> items) {
        return SimpleItemContainer.from(items);
    }

    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static ItemContainer wrap(@Nonnull Container container) {
        return new ContainerToItemContainerAdapter(container);
    }

    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static ItemContainer wrap(@Nonnull IItemHandler itemHandler) {
        return new ItemHandlerToItemContainerAdapter(itemHandler);
    }

    @Contract(pure=true)
    default public int start() {
        return 0;
    }

    @Contract(pure=true)
    public int size();

    @Nonnull
    public ItemStack get(int var1);

    public void set(int var1, @Nonnull ItemStack var2);

    @Contract(pure=true)
    public boolean isValid(int var1, @Nonnull ItemStack var2);

    @Contract(pure=true)
    default public int getSlotCapacity(int slot) {
        return 64;
    }

    default public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, ItemStack.EMPTY);
        }
    }

    @Contract(pure=true)
    default public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    @Contract(value="-> new", pure=true)
    default public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            final int size;
            int i;
            {
                this.size = ItemContainer.this.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public ItemStack next() {
                return ItemContainer.this.get(this.i++);
            }
        };
    }

    @Nonnull
    @Contract(value="_, _ -> new", pure=true)
    default public ItemContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new ItemContainerSlice(this, from, to - from);
    }

    @Nonnull
    @Contract(pure=true)
    default public IItemHandlerModifiable asHandler() {
        return this.asHandler(HandlerIOBehavior.DEFAULT);
    }

    @Nonnull
    @Contract(pure=true)
    default public IItemHandlerModifiable asHandler(HandlerIOBehavior behavior) {
        return new ItemContainerToItemHandlerAdapter(this, behavior);
    }

    @Nonnull
    @Contract(pure=true)
    default public Container asVanillaContainer() {
        return new ItemContainerToContainerAdapter(this);
    }

    @Nonnull
    @Contract(pure=true)
    default public NonNullList<ItemStack> copyToList() {
        NonNullList list = NonNullList.withSize((int)this.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.size(); ++i) {
            list.set(i, (Object)this.get(i).copy());
        }
        return list;
    }
}

