/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import tv.soaryn.xycraft.core.content.volumes.ICacheableVolume;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;

public class VolumeLevelAttachment<T extends ICacheableVolume> {
    final Class<T> _classType;
    final List<BlockPos> _positions = new ArrayList<BlockPos>();
    final Function<BlockPos, T> _anchorFactory;

    private static <T extends ICacheableVolume> Codec<VolumeLevelAttachment<T>> codec(Class<T> classType, Function<BlockPos, T> anchorFactory) {
        return RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.listOf().fieldOf("positions").forGetter(data -> data._positions)).apply((Applicative)builder, blockPos -> new VolumeLevelAttachment((List<BlockPos>)blockPos, classType, anchorFactory)));
    }

    public static <T extends ICacheableVolume> AttachmentType.Builder<VolumeLevelAttachment<T>> builder(Class<T> classType, Function<BlockPos, T> anchorFactory) {
        return AttachmentType.builder(() -> new VolumeLevelAttachment(List.of(), classType, anchorFactory)).serialize(VolumeLevelAttachment.codec(classType, anchorFactory));
    }

    public List<BlockPos> getCenterPositions() {
        return this._positions;
    }

    private VolumeLevelAttachment(List<BlockPos> positions, Class<T> classType, Function<BlockPos, T> anchorFactory) {
        this._positions.addAll(positions);
        this._classType = classType;
        this._anchorFactory = anchorFactory;
    }

    public static <T extends ICacheableVolume> VolumeLevelAttachment<T> of(ServerLevel level, Supplier<AttachmentType<VolumeLevelAttachment<T>>> attachmentTypeSupplier) {
        return (VolumeLevelAttachment)level.getData(attachmentTypeSupplier);
    }

    public static <T extends ICacheableVolume> VolumeLevelAttachment<T> of(Level level, AttachmentType<VolumeLevelAttachment<T>> attachmentType) {
        return (VolumeLevelAttachment)level.getData(attachmentType);
    }

    public static <T extends ICacheableVolume> void load(ServerLevel level, Supplier<AttachmentType<VolumeLevelAttachment<T>>> type) {
        VolumeLevelAttachment cache = (VolumeLevelAttachment)level.getData(type);
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, cache._classType);
        ObjectOpenHashSet invalids = new ObjectOpenHashSet();
        cache._positions.forEach(pos -> {
            ICacheableVolume volume = (ICacheableVolume)cache._anchorFactory.apply((BlockPos)pos);
            if (!volume.isStateValid(level.getBlockState(pos))) {
                invalids.add(pos);
                return;
            }
            int range = volume.getRange();
            lookup.add(volume, pos.offset(-range, -range, -range), pos.offset(range, range, range));
        });
        cache._positions.removeAll((Collection<?>)invalids);
    }

    public static <T extends ICacheableVolume> void add(Level level, BlockPos pos, Supplier<AttachmentType<VolumeLevelAttachment<T>>> type) {
        VolumeLevelAttachment cache = (VolumeLevelAttachment)level.getData(type);
        if (cache._positions.contains(pos)) {
            return;
        }
        cache._positions.add(pos);
        FastVolumeLookup<ICacheableVolume> lookup = FastVolumeLookup.of(level, cache._classType);
        ICacheableVolume volume = (ICacheableVolume)cache._anchorFactory.apply(pos);
        int range = volume.getRange();
        lookup.add(volume, pos.offset(-range, -range, -range), pos.offset(range, range, range));
    }

    public static <T extends ICacheableVolume> void remove(Level level, BlockPos pos, Supplier<AttachmentType<VolumeLevelAttachment<T>>> type) {
        VolumeLevelAttachment cache = (VolumeLevelAttachment)level.getData(type);
        if (!cache._positions.contains(pos)) {
            return;
        }
        cache._positions.remove(pos);
        FastVolumeLookup<T> lookup = FastVolumeLookup.of(level, cache._classType);
        Optional<ICacheableVolume> volume = lookup.find(pos).filter(t -> t.getPos().equals((Object)pos)).findFirst();
        volume.ifPresent(lookup::remove);
    }
}

