/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.memory;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import tv.soaryn.xycraft.api.content.capabilities.HandlerAction;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyHandler;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.config.EnergyParadigm;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
public class PlayerPowerItemLookupAttachment {
    public static final AttachmentType.Builder<PlayerPowerItemLookupAttachment> Builder = AttachmentType.builder(PlayerPowerItemLookupAttachment::new);
    private final IntList _validHolders = new IntArrayList(40);
    private final Int2ObjectMap<PowerHolder> _holders = new Int2ObjectLinkedOpenHashMap(40);

    private PlayerPowerItemLookupAttachment(IAttachmentHolder holder) {
        Player player = (Player)holder;
        Inventory inventory = player.getInventory();
        PlayerPowerItemLookupAttachment.buildLookupTable(this, inventory);
    }

    public long loop(long required, PowerHolderConsumer consumer) {
        int index;
        long remaining = required;
        int[] nArray = this._validHolders.toIntArray();
        int n = nArray.length;
        for (int i = 0; !(i >= n || this._holders.containsKey(index = nArray[i]) && (remaining -= (long)consumer.handle((PowerHolder)this._holders.get(index), remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining)) <= 0L); ++i) {
        }
        return required - remaining;
    }

    public void invalidate(Inventory inventory) {
        for (int i = this._validHolders.size() - 1; i >= 0; --i) {
            int index = this._validHolders.getInt(i);
            PowerHolder holder = (PowerHolder)this._holders.get(index);
            if (holder.invalidate(inventory.getItem(index))) continue;
            this._validHolders.removeInt(i);
        }
    }

    private static void buildLookupTable(PlayerPowerItemLookupAttachment data, Inventory inventory) {
        data._validHolders.clear();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stackInSlot = inventory.getItem(i).copy();
            PowerHolder powerHolder = (PowerHolder)data._holders.computeIfAbsent(i, PowerHolder::new);
            if (!powerHolder.invalidate(stackInSlot)) continue;
            data._validHolders.add(i);
        }
    }

    @SubscribeEvent
    private static void tick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (Ticks.of((IAttachmentHolder)player) % 5L != 0L) {
            return;
        }
        PlayerPowerItemLookupAttachment data = (PlayerPowerItemLookupAttachment)player.getData(CoreAttachments.PlayerPowerSourceLookup);
        PlayerPowerItemLookupAttachment.buildLookupTable(data, player.getInventory());
    }

    public static class PowerHolder {
        public ItemStack Stack;
        public boolean IsValid;
        private Lazy<IEnergyStorage> handler;

        private PowerHolder(int ignored) {
        }

        public boolean invalidate(ItemStack stack) {
            this.Stack = stack;
            IEnergyStorage cap = PowerHolder.getCapability(stack);
            this.IsValid = cap != null;
            this.handler = Lazy.of(() -> PowerHolder.getCapability(this.Stack));
            return this.IsValid;
        }

        public static IEnergyStorage getCapability(ItemStack stack) {
            if (stack.isEmpty()) {
                return null;
            }
            return switch ((EnergyParadigm)((Object)XyCore.ServerConfig.Paradigm.get())) {
                default -> throw new MatchException(null, null);
                case EnergyParadigm.Neo -> (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                case EnergyParadigm.Xynergy -> (IXynergyHandler)stack.getCapability(CoreCapabilities.XynergyStorage.ITEM);
            };
        }

        public int drain(int amount, HandlerAction handlerAction) {
            if (!this.IsValid) {
                return 0;
            }
            IEnergyStorage cap = (IEnergyStorage)this.handler.get();
            if (!cap.canExtract()) {
                return 0;
            }
            return cap.extractEnergy(amount, handlerAction.Value);
        }

        public int fill(int amount, HandlerAction handlerAction) {
            if (!this.IsValid) {
                return 0;
            }
            IEnergyStorage cap = (IEnergyStorage)this.handler.get();
            if (!cap.canReceive()) {
                return 0;
            }
            return cap.receiveEnergy(amount, handlerAction.Value);
        }

        public int getCurrent() {
            if (!this.IsValid) {
                return 0;
            }
            IEnergyStorage cap = (IEnergyStorage)this.handler.get();
            return cap != null ? cap.getEnergyStored() : 0;
        }

        public int getCapacity() {
            if (!this.IsValid) {
                return 0;
            }
            IEnergyStorage cap = (IEnergyStorage)this.handler.get();
            return cap != null ? cap.getMaxEnergyStored() : 0;
        }
    }

    @FunctionalInterface
    public static interface PowerHolderConsumer {
        public int handle(PowerHolder var1, int var2);
    }
}

