/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public final class MathUtils {
    private MathUtils() {
    }

    public static <T> T fromArray(int offset, T ... values) {
        return values[offset % values.length];
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return MathUtils.gcd(b, a % b);
    }

    public static int toInt(long value) {
        return (long)((int)value) != value ? (value > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE) : (int)value;
    }

    public static boolean isAlongAxis(Vec3i pos, Vec3i otherPosition) {
        Vec3i diff = otherPosition.subtract(pos);
        int zeroCount = 0;
        for (Direction.Axis axis : Direction.Axis.values()) {
            int component = diff.get(axis);
            if (component != 0) continue;
            ++zeroCount;
        }
        return zeroCount >= 2;
    }

    public static boolean isAlongAxisAndDiagonal(Vec3i pos, Vec3i otherPosition) {
        Vec3i diff = otherPosition.subtract(pos);
        int zeroCount = 0;
        for (Direction.Axis axis : Direction.Axis.values()) {
            int component = diff.get(axis);
            if (component != 0) continue;
            ++zeroCount;
        }
        if (zeroCount >= 2) {
            return true;
        }
        if (diff.getZ() == 0) {
            return Math.abs(diff.getX()) == Math.abs(diff.getY());
        }
        if (diff.getX() == 0) {
            return Math.abs(diff.getZ()) == Math.abs(diff.getY());
        }
        if (diff.getY() == 0) {
            return Math.abs(diff.getX()) == Math.abs(diff.getZ());
        }
        return false;
    }

    public static long longSum(long currentSum, long amount) {
        if (amount == 0L) {
            return currentSum;
        }
        return amount > 0L ? MathUtils.longSumUp(currentSum, amount) : MathUtils.longSumLow(currentSum, amount);
    }

    public static long longSumUp(long currentSum, long amount) {
        if (currentSum < 0L) {
            return currentSum + amount;
        }
        if (currentSum + amount < 0L) {
            return Long.MAX_VALUE;
        }
        return currentSum + amount;
    }

    public static long longSumLow(long currentSum, long amount) {
        if (currentSum == 0L && amount == 0L) {
            return 0L;
        }
        if (currentSum > 0L) {
            return currentSum + amount;
        }
        if (currentSum + amount >= 0L) {
            return Long.MIN_VALUE;
        }
        return currentSum + amount;
    }
}

