/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public final class PrimitiveUtils {
    public static final int IntLimit = 1000000000;
    public static final long LongLimit = 1000000000000000000L;

    private PrimitiveUtils() {
    }

    public static final class Suppliers {
        private Suppliers() {
        }

        public static final class Bool {
            public static final Supplier<Boolean> False = () -> false;

            public static BooleanSupplier aggregate(BooleanSupplier ... suppliers) {
                return () -> Arrays.stream(suppliers).allMatch(BooleanSupplier::getAsBoolean);
            }

            private Bool() {
            }
        }

        public static final class Long {
            public static final Supplier<java.lang.Long> Zero = () -> 0L;

            private Long() {
            }
        }

        public static final class Int {
            public static final Supplier<Integer> Zero = () -> 0;

            private Int() {
            }
        }
    }
}

