/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.handlers;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import tv.soaryn.xycraft.api.content.capabilities.HandlerAction;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.config.EnergyParadigm;
import tv.soaryn.xycraft.core.content.attachments.accessors.PlayerPowerLookup;
import tv.soaryn.xycraft.core.content.attachments.memory.PlayerPowerItemLookupAttachment;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;

public class EnergyHandlerUtils {
    private EnergyHandlerUtils() {
    }

    public static IEnergyStorage getItemCapability(ItemStack stack) {
        return XyCore.ServerConfig.Paradigm.get() == EnergyParadigm.Xynergy ? (IEnergyStorage)stack.getCapability(CoreCapabilities.XynergyStorage.ITEM) : (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
    }

    public static void mockDrain(Player player, int amount) {
        PlayerPowerItemLookupAttachment lookup = PlayerPowerLookup.of(player);
        lookup.invalidate(player.getInventory());
        long result = lookup.loop(amount, EnergyHandlerUtils::simulateDrain);
        if (result >= (long)amount) {
            lookup.loop(amount, EnergyHandlerUtils::executeDrain);
        }
    }

    public static int simulateDrain(PlayerPowerItemLookupAttachment.PowerHolder holder, int amountRemainingNeeded) {
        return holder.drain(amountRemainingNeeded, HandlerAction.Simulate);
    }

    public static int executeDrain(PlayerPowerItemLookupAttachment.PowerHolder holder, int amountRemainingNeeded) {
        return holder.drain(amountRemainingNeeded, HandlerAction.Execute);
    }

    public static int simulateFill(PlayerPowerItemLookupAttachment.PowerHolder holder, int amountRemainingNeeded) {
        return holder.fill(amountRemainingNeeded, HandlerAction.Simulate);
    }

    public static int executeFill(PlayerPowerItemLookupAttachment.PowerHolder holder, int amountRemainingNeeded) {
        return holder.fill(amountRemainingNeeded, HandlerAction.Execute);
    }
}

