/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.multiblock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import tv.soaryn.xycraft.core.utils.multiblock.BlockUsage;
import tv.soaryn.xycraft.core.utils.multiblock.FormationRules;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;

public record CuboidDescriptor(BlockPos min, BlockPos max) {
    public static final Codec<CuboidDescriptor> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("min").forGetter(CuboidDescriptor::min), (App)BlockPos.CODEC.fieldOf("max").forGetter(CuboidDescriptor::max)).apply((Applicative)builder, CuboidDescriptor::new));
    public static final BinarySerializer<CuboidDescriptor> SerDes = BinarySerializer.ofType(CuboidDescriptor::new, CuboidDescriptor::min, Serializer.BLOCK_POS, CuboidDescriptor::max, Serializer.BLOCK_POS);

    public static CuboidDescriptor around(BlockPos pos, int range) {
        return new CuboidDescriptor(pos.offset(-range, -range, -range), pos.offset(range, range, range));
    }

    public Optional<String> checkForErrors(BlockGetter level, FormationRules rules) {
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        for (int x = this.min.getX(); x <= this.max.getX(); ++x) {
            boolean xFace = x == this.min.getX() || x == this.max.getX();
            for (int y = this.min.getY(); y <= this.max.getY(); ++y) {
                boolean yFace = y == this.min.getY() || y == this.max.getY();
                for (int z = this.min.getZ(); z <= this.max.getZ(); ++z) {
                    boolean zFace = z == this.min.getZ() || z == this.max.getZ();
                    tempPos.set(x, y, z);
                    if (xFace && yFace || xFace && zFace || yFace && zFace) {
                        if (rules.isValid(level, (BlockPos)tempPos, BlockUsage.EDGE)) continue;
                        return Optional.of("Invalid edge at " + tempPos.toShortString());
                    }
                    if (xFace || yFace || zFace) {
                        if (rules.isValid(level, (BlockPos)tempPos, BlockUsage.WALL)) continue;
                        return Optional.of("Invalid wall at " + tempPos.toShortString());
                    }
                    if (rules.isValid(level, (BlockPos)tempPos, BlockUsage.INNER)) continue;
                    return Optional.of("Invalid inner block at " + tempPos.toShortString());
                }
            }
        }
        return Optional.empty();
    }

    public static Either<CuboidDescriptor, String> tryFormOutwards(BlockGetter level, BlockPos origin, FormationRules rules) {
        if (!rules.isValid(level, origin, BlockUsage.INNER)) {
            return Either.right((Object)("No valid inner block at " + origin.toShortString()));
        }
        int[] availableInnerExtents = new int[]{rules.getMaxSize(Direction.Axis.X) - 2, rules.getMaxSize(Direction.Axis.Y) - 2, rules.getMaxSize(Direction.Axis.Z) - 2};
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos().set((Vec3i)origin);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos().set((Vec3i)origin);
        for (Direction direction : Direction.values()) {
            int availableAxisInnerExtents = availableInnerExtents[direction.getAxis().ordinal()];
            Either<Integer, String> result = CuboidDescriptor.tryFindWall(level, tempPos.set((Vec3i)origin), direction, rules, availableAxisInnerExtents);
            Optional error = result.right();
            if (error.isPresent()) {
                return Either.right((Object)((String)error.get()));
            }
            result.ifLeft(amount -> {
                if (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    max.move(direction, amount.intValue());
                } else {
                    min.move(direction, amount.intValue());
                }
                int n = direction.getAxis().ordinal();
                availableInnerExtents[n] = availableInnerExtents[n] - amount;
            });
        }
        CuboidDescriptor descriptor = new CuboidDescriptor(min.immutable(), max.immutable());
        Optional<String> error = descriptor.checkForErrors(level, rules);
        return error.map(Either::right).orElseGet(() -> Either.left((Object)descriptor));
    }

    private static Either<Integer, String> tryFindWall(BlockGetter level, BlockPos.MutableBlockPos pos, Direction direction, FormationRules rules, int maxInnerExtents) {
        pos.move(direction);
        for (int offset = 1; offset <= maxInnerExtents; ++offset) {
            if (!rules.isValid(level, (BlockPos)pos, BlockUsage.INNER)) {
                if (rules.isValid(level, (BlockPos)pos, BlockUsage.WALL)) {
                    return Either.left((Object)offset);
                }
                return Either.right((Object)("No valid inner block or wall at " + pos.toShortString() + " (towards: " + String.valueOf(direction) + ")"));
            }
            pos.move(direction);
        }
        if (rules.isValid(level, (BlockPos)pos, BlockUsage.WALL)) {
            return Either.left((Object)(maxInnerExtents + 1));
        }
        return Either.right((Object)("No valid wall at " + pos.toShortString() + " (towards: " + String.valueOf(direction) + ")"));
    }

    @Override
    public String toString() {
        return "[%s] : [%s]".formatted(this.min.toShortString(), this.max.toShortString());
    }
}

