/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.utils.multiblock.BlockUsage;

public interface FormationRules {
    public int getMaxSize(Direction.Axis var1);

    public boolean isValid(BlockGetter var1, BlockPos var2, BlockUsage var3);

    public static boolean isBlockGenerallyAccepted(BlockGetter level, BlockPos pos, BlockUsage type) {
        BlockState state = level.getBlockState(pos);
        if (type == BlockUsage.WALL) {
            if (state.is(XyCraftTags.Blocks.MultiBlockInvalidFace.tag())) {
                return false;
            }
            if (state.is(XyCraftTags.Blocks.MultiBlockValidFace.tag())) {
                return true;
            }
        } else if (type == BlockUsage.EDGE) {
            if (state.is(XyCraftTags.Blocks.MultiBlockInvalidFrame.tag())) {
                return false;
            }
            if (state.is(XyCraftTags.Blocks.MultiBlockValidFrame.tag())) {
                return true;
            }
        } else if (type == BlockUsage.INNER) {
            if (state.is(XyCraftTags.Blocks.MultiBlockInvalidEmpty.tag())) {
                return false;
            }
            if (state.is(XyCraftTags.Blocks.MultiBlockValidEmpty.tag())) {
                return true;
            }
            return state.isAir();
        }
        return !state.hasBlockEntity() && state.isCollisionShapeFullBlock(level, pos);
    }
}

