/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.rules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.rules.CoreRules;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.core.utils.rules.IRuleType;

public record PropertyRule(String property, String value) implements IRule
{
    public static final MapCodec<PropertyRule> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("property").forGetter(PropertyRule::property), (App)Codec.STRING.fieldOf("value").forGetter(PropertyRule::value)).apply((Applicative)builder, PropertyRule::new));

    public static <T extends Comparable<T>> PropertyRule of(Property<T> property, T value) {
        return new PropertyRule(property.getName(), property.getName(value));
    }

    @Override
    public boolean matches(BlockState state) {
        Property property = state.getProperties().stream().filter(prop -> this.property().equals(prop.getName())).findFirst().orElse(null);
        if (property == null) {
            return this.value() == null;
        }
        Comparable theirValue = state.getValue(property);
        return property.getValue(this.value()).filter((Predicate<Comparable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/Comparable;)Z)((Comparable)theirValue)).isPresent();
    }

    @Override
    @NotNull
    public IRuleType<?> getType() {
        return (IRuleType)CoreRules.RuleProperty.get();
    }
}

