/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.lib.util.NameUtils;

public abstract class LibRecipeProvider
extends RecipeProvider {
    private final String modId;

    public LibRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, String modId) {
        super(packOutput, registries);
        this.modId = modId;
    }

    protected abstract void buildRecipes(RecipeOutput var1);

    protected ResourceLocation modId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)path);
    }

    protected void registerCustomRecipe(RecipeOutput consumer, Function<CraftingBookCategory, Recipe<?>> serializer, ResourceLocation recipeId) {
        SpecialRecipeBuilder.special(serializer).save(consumer, recipeId.toString());
    }

    protected void smeltingAndBlastingRecipes(RecipeOutput consumer, String id, ItemLike ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.of((ItemLike[])new ItemLike[]{ingredientIn}), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(RecipeOutput consumer, String id, TagKey<Item> ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.of(ingredientIn), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(RecipeOutput consumer, String id, Ingredient ingredientIn, ItemLike result, float experienceIn) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)ingredientIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experienceIn, (int)100).unlockedBy("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, this.modId("blasting/" + id));
        SimpleCookingRecipeBuilder.smelting((Ingredient)ingredientIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experienceIn, (int)200).unlockedBy("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, this.modId("smelting/" + id));
    }

    protected void compressionRecipes(RecipeOutput consumer, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        this.compressionRecipes(consumer, RecipeCategory.MISC, block, item, nugget);
    }

    protected void compressionRecipes(RecipeOutput consumer, RecipeCategory category, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        String blockName = NameUtils.fromItem(block).getPath();
        String itemName = NameUtils.fromItem(item).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy("has_item", LibRecipeProvider.has((ItemLike)item)).save(consumer, this.modId(itemName + "_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)9).requires(block).unlockedBy("has_item", LibRecipeProvider.has((ItemLike)item)).save(consumer, this.modId(blockName));
        if (nugget != null) {
            String nuggetName = NameUtils.fromItem(nugget).getPath();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), nugget).unlockedBy("has_item", LibRecipeProvider.has((ItemLike)item)).save(consumer, this.modId(itemName + "_from_nugget"));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (int)9).requires(item).unlockedBy("has_item", LibRecipeProvider.has((ItemLike)item)).save(consumer, this.modId(nuggetName));
        }
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tagKey) {
        return LibRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tagKey).build()});
    }
}

