/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@Deprecated(forRemoval=true)
public class DimensionId {
    private final ResourceKey<Level> id;
    private static final Lazy<DimensionId> OVERWORLD = Lazy.of(() -> new DimensionId((ResourceKey<Level>)Level.OVERWORLD));

    private DimensionId(ResourceKey<Level> id) {
        this.id = id;
    }

    public static DimensionId overworld() {
        return (DimensionId)OVERWORLD.get();
    }

    public static DimensionId fromId(ResourceKey<Level> id) {
        return new DimensionId(id);
    }

    public static DimensionId fromPacket(FriendlyByteBuf buf) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation());
        return new DimensionId((ResourceKey<Level>)key);
    }

    public static DimensionId fromWorld(Level world) {
        return new DimensionId((ResourceKey<Level>)world.dimension());
    }

    public static DimensionId fromResourceLocation(ResourceLocation location) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location);
        return new DimensionId((ResourceKey<Level>)key);
    }

    public ResourceKey<Level> getId() {
        return this.id;
    }

    public ResourceLocation getRegistryName() {
        return this.id.location();
    }

    public String getName() {
        return this.id.location().getPath();
    }

    public boolean isOverworld() {
        return this.id.equals((Object)Level.OVERWORLD);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.id.location());
    }

    public ServerLevel loadWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getLevel(this.id);
    }

    public ServerLevel getWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getLevel(this.id);
    }

    public ServerLevel loadWorld(Level otherWorld) {
        return otherWorld.getServer().getLevel(this.id);
    }

    public static boolean sameDimension(Level world1, Level world2) {
        return world1.dimension().equals(world2.dimension());
    }

    public boolean sameDimension(Level world) {
        return this.id.equals((Object)world.dimension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionId that = (DimensionId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

