/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public final class LootUtils {
    private LootUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static ItemEntity createDroppedItem(ItemStack stack, Entity dropper) {
        double x = dropper.getX();
        double y = dropper.getY((double)(dropper.getBbHeight() / 2.0f));
        double z = dropper.getZ();
        return new ItemEntity(dropper.level(), x, y, z, stack);
    }

    public static Collection<ItemStack> gift(ResourceKey<LootTable> lootTableKey, ServerPlayer player) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return ImmutableList.of();
        }
        LootParams lootParams = new LootParams.Builder(player.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withLuck(player.getLuck()).create(LootContextParamSets.GIFT);
        return server.reloadableRegistries().getLootTable(lootTableKey).getRandomItems(lootParams);
    }
}

