/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.custom;

import java.util.function.Supplier;
import net.micaxs.smokeleaf.block.entity.BaseWeedCropBlockEntity;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseWeedCropBlock
extends CropBlock
implements EntityBlock {
    public static final int FIRST_STAGE_MAX_AGE = 6;
    public static final int SECOND_STAGE_MAX_AGE = 4;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)10);
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    private static final int MAX_PERCENT = 100;
    private static final int MAX_PH = 14;
    public BaseWeedCropBlockEntity blockEntity;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Supplier<Item> seedItem;
    private final int baseN;
    private final int baseP;
    private final int baseK;
    private final int basePh;
    private int baseThc = 0;
    private int baseCbd = 0;

    public BaseWeedCropBlock(BlockBehaviour.Properties properties, Supplier<Item> seedItem) {
        this(properties, seedItem, 0, 0, 0, 7, 0, 0);
    }

    public BaseWeedCropBlock(BlockBehaviour.Properties properties, Supplier<Item> seedItem, int n, int p, int k, int ph, int thc, int cbd) {
        super(properties);
        this.seedItem = seedItem;
        this.baseN = n;
        this.baseP = p;
        this.baseK = k;
        this.basePh = ph;
        this.baseThc = thc;
        this.baseCbd = cbd;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public int getBaseThc() {
        return this.baseThc;
    }

    public int getBaseCbd() {
        return this.baseCbd;
    }

    public int getBaseN() {
        return this.baseN;
    }

    public int getBaseP() {
        return this.baseP;
    }

    public int getBaseK() {
        return this.baseK;
    }

    public int getBasePh() {
        return this.basePh;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.isTop(state)) {
            return SHAPE_BY_AGE[this.getAge(state)];
        }
        return SHAPE_BY_AGE[Math.max(0, Math.min(6, this.getAge(state)))];
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1) || this.isTop(state) || level.getRawBrightness(pos, 0) < 11 || !this.canSurvive(state, (LevelReader)level, pos)) {
            return;
        }
        int age = this.getAge(state);
        if (age >= this.getMaxAge()) {
            return;
        }
        float growthSpeed = BaseWeedCropBlock.getGrowthSpeed((BlockState)this.defaultBlockState(), (BlockGetter)level, (BlockPos)pos);
        if (random.nextInt((int)(25.0f / growthSpeed) + 1) == 0) {
            int nextAge = age + 1;
            level.setBlock(pos, this.getStateForAge(nextAge), 2);
            if (nextAge >= this.getTallAge()) {
                level.setBlockAndUpdate(pos.above(), (BlockState)this.getStateForAge(nextAge).setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        if (this.isTop(state) || !this.canSurvive(state, (LevelReader)level, pos)) {
            return;
        }
        BlockPos above = pos.above();
        if (!level.isEmptyBlock(above) && level.getBlockState(above).getBlock() != this) {
            return;
        }
        int nextAge = this.getAge(state) + this.getBonemealAgeIncrease(level);
        nextAge = Math.min(nextAge, this.getMaxAge());
        level.setBlock(pos, this.getStateForAge(nextAge), 2);
        if (nextAge >= this.getTallAge()) {
            level.setBlockAndUpdate(above, (BlockState)this.getStateForAge(nextAge).setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isTop(state)) {
            BlockState below = level.getBlockState(pos.below());
            return below.getBlock() == this && (Integer)below.getValue((Property)AGE) >= this.getTallAge();
        }
        if (this.getAge(state) >= this.getTallAge()) {
            BlockState above = level.getBlockState(pos.above());
            if (above.getBlock() == this && (Integer)above.getValue((Property)AGE) <= this.getTallAge() - 1) {
                return false;
            }
            return above.getBlock() == this && super.canSurvive(state, level, pos);
        }
        return pos.getY() < level.getMaxBuildHeight() && super.canSurvive(state, level, pos) && level.isEmptyBlock(pos.above());
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)TOP) == false;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state) && (Boolean)state.getValue((Property)TOP) == false;
    }

    public ItemLike getBaseSeedId() {
        return (ItemLike)this.seedItem.get();
    }

    public int getMaxAge() {
        return 10;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, TOP});
    }

    protected boolean isTop(BlockState state) {
        return (Boolean)state.getValue((Property)TOP);
    }

    public BooleanProperty getTop() {
        return TOP;
    }

    public int getTallAge() {
        return 7;
    }

    public float getLocalGrowthSpeed(BlockGetter level, BlockPos pos) {
        return BaseWeedCropBlock.getGrowthSpeed((BlockState)this.defaultBlockState(), (BlockGetter)level, (BlockPos)pos);
    }

    public BaseWeedCropBlockEntity getBlockEntity() {
        if (this.blockEntity instanceof BaseWeedCropBlockEntity) {
            return this.blockEntity;
        }
        return null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.hasProperty((Property)TOP) && ((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return null;
        }
        BaseWeedCropBlockEntity be = (BaseWeedCropBlockEntity)ModBlockEntities.BASE_WEED_CROP_BE.get().create(pos, state);
        if (be != null) {
            be.setThc(this.baseThc);
            be.setCbd(this.baseCbd);
            be.setNitrogen(this.baseN);
            be.setPhosphorus(this.baseP);
            be.setPotassium(this.baseK);
            be.setPh(this.basePh);
        }
        this.blockEntity = be;
        return be;
    }
}

