/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyUtil;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.recipe.GeneratorRecipe;
import net.micaxs.smokeleaf.recipe.GeneratorRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.screen.custom.GeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int INPUT_SLOT = 0;
    private static final int ENERGY_PER_TICK = 40;
    private static final int ENERGY_PUSH_PER_DIRECTION = 40;
    private int generationPerTick = 40;
    private int burnTime = 0;
    private int maxBurnTime = 0;
    private int remainingEnergy = 0;
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.setChanged();
            if (!GeneratorBlockEntity.this.level.isClientSide()) {
                GeneratorBlockEntity.this.level.sendBlockUpdated(GeneratorBlockEntity.this.getBlockPos(), GeneratorBlockEntity.this.getBlockState(), GeneratorBlockEntity.this.getBlockState(), 1);
            }
        }
    };
    protected final ContainerData data;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(64000, 40){

            @Override
            public void onEnergyChanged() {
                GeneratorBlockEntity.this.setChanged();
                GeneratorBlockEntity.this.getLevel().sendBlockUpdated(GeneratorBlockEntity.this.getBlockPos(), GeneratorBlockEntity.this.getBlockState(), GeneratorBlockEntity.this.getBlockState(), 1);
            }
        };
    }

    public GeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.GENERATOR_BE.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> GeneratorBlockEntity.this.burnTime;
                    case 1 -> GeneratorBlockEntity.this.maxBurnTime;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        GeneratorBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        GeneratorBlockEntity.this.maxBurnTime = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return this.ENERGY_STORAGE;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Weed Generator");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new GeneratorMenu(id, inv, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean hasSpace;
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean changed = false;
        boolean bl = hasSpace = this.ENERGY_STORAGE.getEnergyStored() < this.ENERGY_STORAGE.getMaxEnergyStored();
        if (hasSpace) {
            if (this.burnTime <= 0 && this.remainingEnergy <= 0) {
                ItemStack stack = this.itemHandler.getStackInSlot(0);
                Optional<GeneratorRecipe> opt = this.getRecipe(stack);
                if (opt.isPresent()) {
                    GeneratorRecipe recipe = opt.get();
                    this.remainingEnergy = recipe.totalEnergy();
                    this.maxBurnTime = this.burnTime = recipe.computedBurnTime();
                    this.generationPerTick = 40;
                    this.itemHandler.extractItem(0, 1, false);
                    changed = true;
                }
            } else if (this.remainingEnergy > 0) {
                int toGenerate = Math.min(this.generationPerTick, this.remainingEnergy);
                int accepted = this.ENERGY_STORAGE.receiveEnergy(toGenerate, false);
                if (accepted > 0) {
                    this.remainingEnergy -= accepted;
                    if (this.burnTime > 0) {
                        --this.burnTime;
                    }
                    changed = true;
                }
                if (this.remainingEnergy <= 0) {
                    this.burnTime = 0;
                }
            }
        }
        if (changed) {
            GeneratorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
        this.pushEnergyToNeighbours();
        boolean canStart = hasSpace && this.remainingEnergy <= 0 && this.getRecipe(this.itemHandler.getStackInSlot(0)).isPresent();
        boolean shouldPower = this.burnTime > 0 || canStart;
        BlockState current = this.getBlockState();
        if (current.hasProperty((Property)BlockStateProperties.POWERED) && (Boolean)current.getValue((Property)BlockStateProperties.POWERED) != shouldPower) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)current.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldPower)));
        }
    }

    private Optional<GeneratorRecipe> getRecipe(ItemStack stack) {
        if (this.level == null || stack.isEmpty()) {
            return Optional.empty();
        }
        GeneratorRecipeInput input = new GeneratorRecipeInput(stack);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.GENERATOR_TYPE.get(), (RecipeInput)input, this.level).map(RecipeHolder::value);
    }

    private void pushEnergyToNeighbours() {
        if (this.level == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = this.worldPosition.relative(dir);
            if (!ModEnergyUtil.doesBlockHaveEnergyStorage(neighbor, this.level)) continue;
            ModEnergyUtil.move(this.worldPosition, neighbor, 40, this.level);
        }
    }

    public int getConfiguredBurnTimeForDisplay() {
        return this.maxBurnTime;
    }

    public boolean canBurn(ItemStack stack) {
        return stack.getItem() instanceof BaseWeedItem || stack.getItem() instanceof BaseBudItem;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("generator.inventory", (Tag)this.itemHandler.serializeNBT(provider));
        tag.putInt("generator.burnTime", this.burnTime);
        tag.putInt("generator.maxBurnTime", this.maxBurnTime);
        tag.putInt("generator.remainingEnergy", this.remainingEnergy);
        tag.putInt("generator.genPerTick", this.generationPerTick);
        tag.putInt("generator.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler.deserializeNBT(provider, tag.getCompound("generator.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("generator.energy"));
        this.burnTime = tag.getInt("generator.burnTime");
        this.maxBurnTime = tag.getInt("generator.maxBurnTime");
        this.remainingEnergy = tag.getInt("generator.remainingEnergy");
        this.generationPerTick = tag.getInt("generator.genPerTick");
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
    }
}

