/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.fluid.ModFluids;
import net.micaxs.smokeleaf.recipe.IngredientWithCount;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.MutatorRecipe;
import net.micaxs.smokeleaf.screen.custom.MutatorMenu;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutatorBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int ENERGY_CONSTANT = 40;
    private static final int BUCKET_SLOT = 0;
    private static final int SEED_INPUT_SLOT = 1;
    private static final int EXTRACT_INPUT_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 82;
    public final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            MutatorBlockEntity.this.setChanged();
            if (!MutatorBlockEntity.this.level.isClientSide()) {
                MutatorBlockEntity.this.level.sendBlockUpdated(MutatorBlockEntity.this.getBlockPos(), MutatorBlockEntity.this.getBlockState(), MutatorBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.is(ModFluids.HASH_OIL_BUCKET) || stack.is(ModFluids.HEMP_OIL_BUCKET)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> stack.is(ModTags.WEED_SEEDS);
                case 2 -> stack.is(ModTags.WEED_EXTRACTS);
                case 3 -> false;
                default -> false;
            };
        }
    };
    private static final int ENERGY_TRANSFER_AMOUNT = 320;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final FluidTank FLUID_TANK = this.createFluidTank();

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.itemHandler;
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(64000, 320){

            @Override
            public void onEnergyChanged() {
                MutatorBlockEntity.this.setChanged();
                MutatorBlockEntity.this.getLevel().sendBlockUpdated(MutatorBlockEntity.this.getBlockPos(), MutatorBlockEntity.this.getBlockState(), MutatorBlockEntity.this.getBlockState(), 1);
            }
        };
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    private FluidTank createFluidTank() {
        return new FluidTank(8000){

            protected void onContentsChanged() {
                MutatorBlockEntity.this.setChanged();
                if (!MutatorBlockEntity.this.level.isClientSide()) {
                    MutatorBlockEntity.this.level.sendBlockUpdated(MutatorBlockEntity.this.getBlockPos(), MutatorBlockEntity.this.getBlockState(), MutatorBlockEntity.this.getBlockState(), 3);
                }
                super.onContentsChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    public FluidStack getFluid() {
        return this.FLUID_TANK.getFluid();
    }

    public IFluidHandler getTank(@Nullable Direction direction) {
        return this.FLUID_TANK;
    }

    public MutatorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.MUTATOR_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> MutatorBlockEntity.this.progress;
                    case 1 -> MutatorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        MutatorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        MutatorBlockEntity.this.maxProgress = value;
                        break;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.literal((String)"Seed Mutator");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new MutatorMenu(i, inventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        boolean shouldBePowered;
        boolean hasFluid;
        boolean hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        boolean bl = hasFluid = !this.FLUID_TANK.isEmpty();
        if (this.hasFluidItemInSourceSlot()) {
            this.transferItemFluidToFluidTank();
        }
        if (hasEnergy && hasFluid && this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (level.random.nextInt(2) == 0) {
                double x = (double)blockPos.getX() + 0.5;
                double y = (double)blockPos.getY() + 1.0;
                double z = (double)blockPos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            MutatorBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            MutatorBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        boolean bl2 = shouldBePowered = this.progress > 0 || hasEnergy && this.hasRecipe();
        if ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) != shouldBePowered) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
        }
    }

    private void craftItem() {
        Optional<RecipeHolder<MutatorRecipe>> opt = this.getCurrentRecipe();
        if (opt.isEmpty()) {
            return;
        }
        MutatorRecipe rec = (MutatorRecipe)opt.get().value();
        ItemStack output = rec.output().copy();
        this.removeInputs(rec);
        this.FLUID_TANK.drain(rec.getFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        ItemStack existing = this.itemHandler.getStackInSlot(3);
        int newCount = existing.getCount() + output.getCount();
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)output.getItem(), newCount));
    }

    private void removeInputs(MutatorRecipe rec) {
        NonNullList<IngredientWithCount> inputs = rec.inputItems();
        if (!inputs.isEmpty()) {
            int c0 = Math.max(1, ((IngredientWithCount)inputs.get(0)).count());
            this.itemHandler.extractItem(1, c0, false);
        }
        if (inputs.size() > 1) {
            int c1 = Math.max(1, ((IngredientWithCount)inputs.get(1)).count());
            this.itemHandler.extractItem(2, c1, false);
        }
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<MutatorRecipe>> opt = this.getCurrentRecipe();
        if (opt.isEmpty()) {
            return false;
        }
        MutatorRecipe rec = (MutatorRecipe)opt.get().value();
        ItemStack output = rec.output();
        if (!this.canInsertAmountIntoOutputSlot(output.getCount()) || !this.canInsertItemIntoOutputSlot(output)) {
            return false;
        }
        FluidStack tank = this.FLUID_TANK.getFluid();
        FluidStack required = rec.getFluid();
        if (tank.isEmpty()) {
            return false;
        }
        if (tank.getFluid() != required.getFluid()) {
            return false;
        }
        return tank.getAmount() >= required.getAmount();
    }

    private Optional<RecipeHolder<MutatorRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        ItemStack seedStack = this.itemHandler.getStackInSlot(1);
        ItemStack extractStack = this.itemHandler.getStackInSlot(2);
        if (seedStack.isEmpty() || extractStack.isEmpty()) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.MUTATOR_TYPE.get()).stream().filter(holder -> {
            MutatorRecipe rec = (MutatorRecipe)holder.value();
            NonNullList<IngredientWithCount> inputs = rec.inputItems();
            if (inputs.isEmpty()) {
                return false;
            }
            boolean seedOk = this.matches(inputs, 0, seedStack);
            boolean extractOk = inputs.size() < 2 || this.matches(inputs, 1, extractStack);
            FluidStack required = rec.getFluid();
            FluidStack inTank = this.FLUID_TANK.getFluid();
            boolean fluidOk = !inTank.isEmpty() && inTank.getFluid() == required.getFluid() && inTank.getAmount() >= required.getAmount();
            return seedOk && extractOk && fluidOk;
        }).findFirst();
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.itemHandler.getStackInSlot(3).isEmpty() || this.itemHandler.getStackInSlot(3).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.itemHandler.getStackInSlot(3).isEmpty() ? 64 : this.itemHandler.getStackInSlot(3).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(3).getCount();
        return maxCount >= currentCount + count;
    }

    private void transferItemFluidToFluidTank() {
        ItemStack bucketStack = this.itemHandler.getStackInSlot(0);
        if (bucketStack.isEmpty()) {
            return;
        }
        FluidStack fluidInBucket = FluidUtil.getFluidContained((ItemStack)bucketStack).orElse(FluidStack.EMPTY);
        if (fluidInBucket.isEmpty()) {
            return;
        }
        int filledAmount = this.FLUID_TANK.fill(fluidInBucket, IFluidHandler.FluidAction.SIMULATE);
        if (filledAmount > 0) {
            this.FLUID_TANK.fill(fluidInBucket, IFluidHandler.FluidAction.EXECUTE);
            ItemStack emptyBucket = new ItemStack((ItemLike)bucketStack.getItem().getCraftingRemainingItem());
            this.itemHandler.setStackInSlot(0, emptyBucket);
        }
    }

    private boolean hasFluidItemInSourceSlot() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return !stack.isEmpty() && FluidUtil.getFluidContained((ItemStack)stack).isPresent();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean matches(NonNullList<IngredientWithCount> inputs, int index, ItemStack stack) {
        if (index >= inputs.size()) {
            return false;
        }
        IngredientWithCount need = (IngredientWithCount)inputs.get(index);
        int required = Math.max(1, need.count());
        return need.ingredient().test(stack) && stack.getCount() >= required;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("mutator.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("mutator.progress", this.progress);
        tag.putInt("mutator.maxProgress", this.maxProgress);
        tag.putInt("mutator.energy", this.ENERGY_STORAGE.getEnergyStored());
        tag = this.FLUID_TANK.writeToNBT(registries, tag);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("mutator.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("mutator.energy"));
        this.progress = tag.getInt("mutator.progress");
        this.maxProgress = tag.getInt("mutator.maxProgress");
        this.FLUID_TANK.readFromNBT(registries, tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

