/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.SequencerRecipe;
import net.micaxs.smokeleaf.recipe.SequencerRecipeInput;
import net.micaxs.smokeleaf.screen.custom.SequencerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequencerBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int DNA_SLOT = 0;
    private static final int BASE_EXTRACT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int ENERGY_TRANSFER_AMOUNT = 320;
    private int progress = 0;
    private int maxProgress = 82;
    protected final ContainerData data;
    public final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            SequencerBlockEntity.this.setChanged();
            if (!SequencerBlockEntity.this.level.isClientSide()) {
                SequencerBlockEntity.this.level.sendBlockUpdated(SequencerBlockEntity.this.getBlockPos(), SequencerBlockEntity.this.getBlockState(), SequencerBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.is(ModItems.DNA_STRAND);
                case 1 -> stack.is(ModItems.BASE_EXTRACT);
                case 2 -> false;
                default -> false;
            };
        }
    };
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(64000, 320){

        @Override
        public void onEnergyChanged() {
            SequencerBlockEntity.this.setChanged();
            SequencerBlockEntity.this.getLevel().sendBlockUpdated(SequencerBlockEntity.this.getBlockPos(), SequencerBlockEntity.this.getBlockState(), SequencerBlockEntity.this.getBlockState(), 1);
        }
    };

    public SequencerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SEQUENCER_BE.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> SequencerBlockEntity.this.progress;
                    case 1 -> SequencerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        SequencerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        SequencerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.literal((String)"DNA Sequencer");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new SequencerMenu(id, inv, this, this.data);
    }

    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction dir) {
        return this.ENERGY_STORAGE;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean powered;
        boolean hasEnergy;
        if (level.isClientSide()) {
            return;
        }
        boolean bl = hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        if (hasEnergy && this.hasRecipe()) {
            ++this.progress;
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (this.progress >= this.maxProgress) {
                this.craftItem();
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
        SequencerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        boolean bl2 = powered = this.progress > 0 || hasEnergy && this.hasRecipe();
        if ((Boolean)state.getValue((Property)BlockStateProperties.POWERED) != powered) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    private Optional<RecipeHolder<SequencerRecipe>> getCurrentRecipe() {
        SequencerRecipeInput input = new SequencerRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.SEQUENCER_TYPE.get(), (RecipeInput)input, this.level);
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<SequencerRecipe>> opt = this.getCurrentRecipe();
        if (opt.isEmpty()) {
            if (!this.level.isClientSide()) {
                ItemStack dna = this.itemHandler.getStackInSlot(0);
                ItemStack itemStack = this.itemHandler.getStackInSlot(1);
            }
            return false;
        }
        ItemStack outputSimulated = ((SequencerRecipe)opt.get().value()).assemble(new SequencerRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1)), (HolderLookup.Provider)this.level.registryAccess());
        return this.canInsertItemIntoOutputSlot(outputSimulated) && this.canInsertAmountIntoOutputSlot(outputSimulated.getCount());
    }

    private void craftItem() {
        Optional<RecipeHolder<SequencerRecipe>> opt = this.getCurrentRecipe();
        if (opt.isEmpty()) {
            return;
        }
        SequencerRecipe recipe = (SequencerRecipe)opt.get().value();
        ItemStack output = recipe.assemble(new SequencerRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1)), (HolderLookup.Provider)this.level.registryAccess());
        if (output.isEmpty()) {
            return;
        }
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(0, 1, false);
        ItemStack existing = this.itemHandler.getStackInSlot(2);
        if (existing.isEmpty()) {
            this.itemHandler.setStackInSlot(2, output);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)output)) {
            existing.grow(output.getCount());
        }
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack stack) {
        ItemStack existing = this.itemHandler.getStackInSlot(2);
        return existing.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        ItemStack existing = this.itemHandler.getStackInSlot(2);
        if (existing.isEmpty()) {
            return count <= 64;
        }
        return existing.getCount() + count <= existing.getMaxStackSize();
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("sequencer.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("sequencer.progress", this.progress);
        tag.putInt("sequencer.maxProgress", this.maxProgress);
        tag.putInt("sequencer.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("sequencer.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("sequencer.energy"));
        this.progress = tag.getInt("sequencer.progress");
        this.maxProgress = tag.getInt("sequencer.maxProgress");
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookup) {
        super.onDataPacket(net, pkt, lookup);
    }
}

