/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.micaxs.smokeleaf.block.entity.GrowPotBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class GrowPotRenderer
implements BlockEntityRenderer<GrowPotBlockEntity> {
    private final BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
    private static final float XZ_SCALE = 0.75f;
    private static final float Y_BASE = 1.0f;
    private static final float POT_HEIGHT = 0.5f;
    private static final float SOIL_HEIGHT = 0.1875f;
    private static final float MAX_TOTAL_HEIGHT = 2.0f;
    private static final float MAX_CROP_HEIGHT = 2.0f;
    private static final float CROP_Y_SCALE = Math.max(0.0f, 0.65625f);

    public GrowPotRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(GrowPotBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BlockState cropBottom;
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockState soil = be.getSoilState();
        if (soil != null) {
            pose.pushPose();
            pose.translate(0.5, 0.0, 0.5);
            pose.scale(0.75f, 0.1875f, 0.75f);
            pose.translate(-0.5, 0.0, -0.5);
            pose.translate(0.0, 1.0, 0.0);
            this.dispatcher.renderSingleBlock(soil, pose, buffers, packedLight, OverlayTexture.NO_OVERLAY);
            pose.popPose();
        }
        if ((cropBottom = be.getBottomCropStateForRender()) != null) {
            pose.pushPose();
            pose.translate(0.5, 0.0, 0.5);
            pose.scale(0.75f, CROP_Y_SCALE, 0.75f);
            pose.translate(-0.5, 0.0, -0.5);
            pose.translate(0.0, (double)0.6f, 0.0);
            this.dispatcher.renderSingleBlock(cropBottom, pose, buffers, packedLight, OverlayTexture.NO_OVERLAY);
            BlockState cropTop = be.getTopCropStateForRender();
            if (cropTop != null) {
                pose.translate(0.0, 1.0, 0.0);
                this.dispatcher.renderSingleBlock(cropTop, pose, buffers, packedLight, OverlayTexture.NO_OVERLAY);
            }
            pose.popPose();
        }
    }

    public boolean shouldRenderOffScreen(GrowPotBlockEntity be) {
        return true;
    }
}

