/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class EchoLocationParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float baseSize;

    protected EchoLocationParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(level, x, y, z, vx, vy, vz);
        this.sprites = sprites;
        this.gravity = 0.0f;
        this.friction = 0.86f;
        this.lifetime = 10 + this.random.nextInt(8);
        this.quadSize = this.baseSize = 0.08f + this.random.nextFloat() * 0.04f;
        this.xd = vx;
        this.yd = vy * 0.05;
        this.zd = vz;
        this.rCol = 0.55f + this.random.nextFloat() * 0.1f;
        this.gCol = 0.9f;
        this.bCol = 1.0f;
        this.alpha = 0.9f;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        float t = (float)this.age / (float)this.lifetime;
        this.quadSize = this.baseSize * (1.0f + 2.2f * t);
        this.alpha = 0.95f * (1.0f - t);
        this.yd += 0.002;
        this.xd *= 0.96;
        this.zd *= 0.96;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new EchoLocationParticle(level, x, y, z, vx, vy, vz, this.sprites);
        }
    }
}

