/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.recipe.JointRecipe;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class JointRecipeCategory
implements IRecipeCategory<JointRecipe> {
    public static final RecipeType<JointRecipe> JOINT_RECIPE_TYPE = RecipeType.create((String)"smokeleafindustries", (String)"joint", JointRecipe.class);
    private static final ResourceLocation VANILLA_BG = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/crafting_table.png");
    private static final TagKey<Item> JOINT_WEEDS = ModTags.WEEDS;
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final Component title;

    private static List<ItemStack> weedStacks() {
        return BuiltInRegistries.ITEM.getTag(JOINT_WEEDS).map(tag -> tag.stream().map(h -> new ItemStack((ItemLike)h.value())).toList()).orElse(List.of());
    }

    public JointRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(VANILLA_BG, 29, 16, 116, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.PAPER));
        this.title = Component.translatable((String)"jei.smokeleafindustries.category.joint");
    }

    public RecipeType<JointRecipe> getRecipeType() {
        return JOINT_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JointRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStack(new ItemStack((ItemLike)Items.PAPER));
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 37).addItemStack(new ItemStack((ItemLike)Items.PAPER));
        List<ItemStack> weeds = JointRecipeCategory.weedStacks();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).addItemStacks(weeds);
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 19).addItemStacks(weeds);
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addItemStack(new ItemStack((ItemLike)recipe.getTobaccoItem()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.getResultItem(null));
    }
}

