/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.recipe.ManualGrinderRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ManualGrinderRecipeCategory
implements IRecipeCategory<ManualGrinderRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"manual_grinder");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/jei_bg.png");
    public static final RecipeType<ManualGrinderRecipe> RECIPE_TYPE = new RecipeType(UID, ManualGrinderRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated progress;

    public ManualGrinderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 110, 50);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.MANUAL_GRINDER.get()));
        IDrawableStatic arrow = guiHelper.createDrawable(TEXTURE, 110, 0, 24, 17);
        this.progress = guiHelper.createAnimatedDrawable(arrow, 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<ManualGrinderRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.smokeleafindustries.manual_grinder");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ManualGrinderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 16).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 16).addItemStack(recipe.getResultItem((HolderLookup.Provider)(Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : null)).copy());
    }

    public void draw(ManualGrinderRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.progress.draw(guiGraphics, 42, 16);
        Minecraft mc = Minecraft.getInstance();
        String ticks = recipe.grindTime() + " Ticks";
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"jei.smokeleafindustries.grind_time", (Object[])new Object[]{ticks}), 22, 38, 0xB8B8B8, false);
    }

    public int getWidth() {
        return 110;
    }

    public int getHeight() {
        return 50;
    }
}

