/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.recipe.MutatorRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class MutatorRecipeCategory
implements IRecipeCategory<MutatorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"mutator");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/mutator/mutator_gui.png");
    public static final RecipeType<MutatorRecipe> MUTATOR_RECIPE_TYPE = new RecipeType(UID, MutatorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final int FLUID_X = 50;
    private static final int FLUID_Y = 10;
    private static final int FLUID_W = 16;
    private static final int FLUID_H = 61;
    private static final int FLUID_CAPACITY = 8000;
    private static final int SEED_X = 81;
    private static final int SEED_Y = 10;
    private static final int EXTRACT_X = 101;
    private static final int EXTRACT_Y = 10;
    private static final int OUTPUT_X = 81;
    private static final int OUTPUT_Y = 55;

    public MutatorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 5, 5, 168, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.MUTATOR.get()));
    }

    public RecipeType<MutatorRecipe> getRecipeType() {
        return MUTATOR_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.smokeleafindustries.mutator");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MutatorRecipe recipe, IFocusGroup focuses) {
        ItemStack out;
        FluidStack fluid;
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        if (ingredients.size() > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 81, 10).addIngredients((Ingredient)ingredients.get(0));
        }
        if (ingredients.size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 101, 10).addIngredients((Ingredient)ingredients.get(1));
        }
        if (!(fluid = recipe.getFluid()).isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 10).setFluidRenderer(8000L, false, 16, 61).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fluid.copy());
        }
        if (!(out = recipe.output()).isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 55).addItemStack(out.copy());
        }
    }

    public void draw(MutatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 90;
    }
}

